/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.util.HashMap;
import java.util.Iterator;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkStub;

public class ChunkMD {
    public volatile float[][] surfaceSlopes;
    public volatile float[][] sliceSlopes;
    public final abw worldObj;
    public final int worldHeight;
    public final Boolean hasNoSky;
    public final ChunkStub stub;
    public final abp coord;
    public Boolean render;
    private int discards;

    public ChunkMD(adr chunk, Boolean render, abw worldObj) {
        this(chunk, render, worldObj, false);
    }

    public ChunkMD(adr chunk, Boolean render, abw worldObj, boolean doErrorChecks) {
        this(new ChunkStub(chunk), render, worldObj);
        if (chunk.g() || !chunk.d) {
            render = false;
        }
    }

    public ChunkMD(ChunkStub stub, Boolean render, abw worldObj) {
        this.stub = stub;
        this.render = render;
        this.worldObj = worldObj;
        this.worldHeight = worldObj.S();
        this.hasNoSky = worldObj.t.g;
        this.coord = new abp(stub.g, stub.h);
    }

    public int discard(int i) {
        this.discards = Math.max(0, this.discards + i);
        return this.discards;
    }

    public aqz getBlock(int x2, int y, int z) {
        int blockId = this.stub.a(x2, y, z);
        return aqz.s[blockId];
    }

    public int getSavedLightValue(ach par1EnumSkyBlock, int x2, int y, int z) {
        return this.stub.a(par1EnumSkyBlock, x2, Math.min(y, this.worldHeight - 1), z);
    }

    public int getSlopeHeightValue(int x2, int z) {
        try {
            int y = this.stub.b(x2, z);
            if (y < 1) {
                return 0;
            }
            aqz block = this.getBlock(x2, y, z);
            while (y > 0 && block == null || BlockUtils.hasFlag(block, BlockUtils.Flag.NoShadow)) {
                block = this.getBlock(x2, --y, z);
            }
            return y;
        }
        catch (Exception e) {
            JourneyMap.getLogger().warning("Couldn't get safe height at " + x2 + "," + z + ": " + e);
            return this.stub.b(x2, z);
        }
    }

    public int hashCode() {
        return this.coord.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        if (this.stub.g != other.stub.g) {
            return false;
        }
        return this.stub.h == other.stub.h;
    }

    public String toString() {
        return "ChunkStubMD [" + this.stub.g + ", " + this.stub.h + "]";
    }

    public static class Set
    extends HashMap<abp, ChunkMD>
    implements Iterable<ChunkMD> {
        public Set(int i) {
            super(i);
        }

        public void put(ChunkMD chunkMd) {
            super.put(chunkMd.coord, chunkMd);
        }

        public void add(ChunkMD chunkMd) {
            super.put(chunkMd.coord, chunkMd);
        }

        public ChunkMD remove(ChunkMD chunkMd) {
            return (ChunkMD)super.remove(chunkMd.coord);
        }

        @Override
        public Iterator<ChunkMD> iterator() {
            return this.values().iterator();
        }
    }
}

