/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.entity.RenderFacade;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;

public class EntityHelper {
    private static int MAX_ENTITIES = 16;
    private static int lateralDistance = PropertyManager.getInstance().getInteger(PropertyManager.Key.CHUNK_OFFSET) * 8;
    private static int verticalDistance = lateralDistance / 2;

    public static List getEntitiesNearby(String timerName, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        atv mc = atv.w();
        asx bb = EntityHelper.getBB((bex)mc.h);
        List list = new ArrayList();
        try {
            for (Class entityClass : entityClasses) {
                list.addAll(mc.f.a(entityClass, bb));
            }
            if (list.size() > MAX_ENTITIES) {
                Collections.sort(list, new EntityDistanceComparator((uf)mc.h));
                list = list.subList(0, MAX_ENTITIES);
            }
        }
        catch (Throwable t2) {
            JourneyMap.getLogger().warning("Failed to " + timerName + ": " + LogFormatter.toString(t2));
        }
        timer.stop();
        return list;
    }

    public static List getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", th.class);
    }

    public static List<ub> getVillagersNearby() {
        return EntityHelper.getEntitiesNearby("getVillagersNearby", ub.class);
    }

    public static List<nl> getAnimalsNearby() {
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", rp.class, rv.class, se.class);
    }

    public static List<uf> getPlayersNearby() {
        atv mc = atv.w();
        if (!mc.B()) {
            int x2 = mc.h.aj << 4;
            int radius = 512;
            int z = mc.h.al << 4;
            asx bb = asx.a((double)(x2 - radius), (double)0.0, (double)(z - radius), (double)(x2 + radius), (double)mc.f.R(), (double)(z + radius));
            List list = mc.f.a(bey.class, bb);
            if (list.size() > MAX_ENTITIES) {
                Collections.sort(list, new EntityDistanceComparator((uf)mc.h));
                list = list.subList(0, MAX_ENTITIES);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private static asx getBB(bex player) {
        return asx.a((double)player.u, (double)player.v, (double)player.w, (double)player.u, (double)player.v, (double)player.w).b((double)lateralDistance, (double)verticalDistance, (double)lateralDistance);
    }

    public static double getHeading(nn entity) {
        if (entity instanceof og) {
            return EntityHelper.getHeading(((og)entity).aP);
        }
        return EntityHelper.getHeading(entity.A);
    }

    public static double getHeading(float rotationYaw) {
        double degrees = Math.round(rotationYaw % 360.0f);
        return degrees;
    }

    public static Map<Object, Map> buildEntityIdMap(List<LinkedHashMap> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, new EntityMapComparator());
        }
        LinkedHashMap<Object, Map> idMap = new LinkedHashMap<Object, Map>(list.size());
        for (Map map : list) {
            idMap.put("id" + map.get((Object)EntityKey.entityId), map);
        }
        return idMap;
    }

    public static String getFileName(nn entity) {
        bgm entityRender = bgl.a.a(entity);
        if (entityRender instanceof bgt) {
            switch (((rs)entity).bT()) {
                case 1: {
                    return "horse/donkey.png";
                }
                case 2: {
                    return "horse/mule.png";
                }
                case 3: {
                    return "horse/zombiehorse.png";
                }
                case 4: {
                    return "horse/skeletonhorse.png";
                }
            }
            return "horse/horse.png";
        }
        bjo loc = RenderFacade.getEntityTexture(entityRender, entity);
        if (loc.b().equals("minecraft")) {
            String search;
            String tex = loc.a();
            int i = tex.lastIndexOf(search = "/entity/");
            if (i >= 0) {
                tex = tex.substring(i + search.length());
            }
            return tex;
        }
        return loc.b() + "/" + loc.a();
    }

    public static class EntityDistanceComparator
    implements Comparator<nn> {
        final uf player;

        EntityDistanceComparator(uf player) {
            this.player = player;
        }

        @Override
        public int compare(nn o1, nn o2) {
            return Double.compare(o1.e((nn)this.player), o2.e((nn)this.player));
        }
    }

    public static class EntityMapComparator
    implements Comparator<Map> {
        @Override
        public int compare(Map o1, Map o2) {
            Integer n;
            Integer n2;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.containsKey((Object)EntityKey.customName)) {
                n2 = o1rank;
                n = o1rank = Integer.valueOf(o1rank + 1);
            } else if (o1.containsKey((Object)EntityKey.username)) {
                o1rank = o1rank + 2;
            }
            if (o2.containsKey((Object)EntityKey.customName)) {
                n2 = o2rank;
                n = o2rank = Integer.valueOf(o2rank + 1);
            } else if (o2.containsKey((Object)EntityKey.username)) {
                o2rank = o2rank + 2;
            }
            return o1rank.compareTo(o2rank);
        }
    }
}

