/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;

public abstract class ImageSet {
    protected final Map<Constants.MapType, Wrapper> imageWrappers;
    protected final Object lock = new Object();

    public ImageSet() {
        this.imageWrappers = Collections.synchronizedMap(new HashMap(3));
    }

    protected abstract Wrapper getWrapper(Constants.MapType var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLegacy() {
        Object object = this.lock;
        synchronized (object) {
            Wrapper wrapper = this.imageWrappers.get((Object)Constants.MapType.OBSOLETE);
            return wrapper != null;
        }
    }

    public BufferedImage getImage(Constants.MapType mapType) {
        return this.getWrapper(mapType).getImage();
    }

    public File getFile(Constants.MapType mapType) {
        return this.getWrapper(mapType).getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Constants.MapType mapType, BufferedImage image) {
        Object object = this.lock;
        synchronized (object) {
            Wrapper wrapper = this.imageWrappers.get((Object)mapType);
            if (wrapper != null) {
                wrapper.setImage(image);
            } else {
                this.addWrapper(mapType, image);
            }
        }
    }

    public void setDirtyFor(Constants.MapType mapType) {
        Wrapper wrapper = this.imageWrappers.get((Object)mapType);
        if (wrapper != null) {
            wrapper.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk(boolean force) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Wrapper> list = new ArrayList<Wrapper>(this.imageWrappers.values());
            Collections.sort(list, new WrapperComparator());
            for (Wrapper wrapper : list) {
                if (!force && !wrapper.isDirty()) continue;
                wrapper.writeToDisk();
            }
            this.imageWrappers.remove((Object)Constants.MapType.OBSOLETE);
        }
    }

    public boolean isDirty() {
        for (Wrapper wrapper : this.imageWrappers.values()) {
            if (!wrapper.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean updatedSince(Constants.MapType mapType, long time) {
        for (Wrapper wrapper : this.imageWrappers.values()) {
            if (!(mapType != null ? wrapper.getMapType() == mapType && wrapper.getTimestamp() > time : wrapper.getTimestamp() > time)) continue;
            return true;
        }
        return false;
    }

    protected BufferedImage copyImage(BufferedImage image) {
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics g = copy.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return copy;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName()).append("[ ");
        Iterator<Wrapper> iter = this.imageWrappers.values().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(" ]").toString();
    }

    public void clear() {
        this.imageWrappers.clear();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    protected abstract Wrapper addWrapper(Constants.MapType var1, BufferedImage var2);

    protected Wrapper addWrapper(Constants.MapType mapType, File imageFile, BufferedImage image) {
        return this.addWrapper(new Wrapper(mapType, imageFile, image));
    }

    protected Wrapper addWrapper(Wrapper wrapper) {
        this.imageWrappers.put(wrapper.mapType, wrapper);
        return wrapper;
    }

    class WrapperComparator
    implements Comparator<Wrapper> {
        WrapperComparator() {
        }

        @Override
        public int compare(Wrapper o1, Wrapper o2) {
            return o1.mapType.compareTo(o2.mapType);
        }
    }

    class Wrapper {
        static final String delim = " : ";
        final Constants.MapType mapType;
        final File imageFile;
        BufferedImage _image = null;
        boolean _dirty = true;
        long timestamp = System.currentTimeMillis();

        Wrapper(Constants.MapType mapType, File imageFile, BufferedImage image) {
            this.mapType = mapType;
            this.imageFile = imageFile;
            this.setImage(image);
            if (mapType == Constants.MapType.OBSOLETE) {
                this._dirty = false;
            }
        }

        void setImage(BufferedImage image) {
            if (image != this._image) {
                this.setDirty();
            }
            this._image = image;
        }

        File getFile() {
            return this.imageFile;
        }

        Constants.MapType getMapType() {
            return this.mapType;
        }

        BufferedImage getImage() {
            return this._image;
        }

        void setDirty() {
            this._dirty = true;
            this.timestamp = new Date().getTime();
        }

        long getTimestamp() {
            return this.timestamp;
        }

        boolean isDirty() {
            return this._dirty;
        }

        protected void writeToDisk() {
            try {
                if (this.mapType == Constants.MapType.OBSOLETE) {
                    if (this.imageFile.exists()) {
                        this.imageFile.delete();
                    }
                    return;
                }
                if (this._image == null) {
                    JourneyMap.getLogger().warning("Null image for " + this);
                } else {
                    File dir = this.imageFile.getParentFile();
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    ImageIO.write((RenderedImage)this._image, "png", new FileOutputStream(this.imageFile));
                    if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                        JourneyMap.getLogger().fine("Wrote to disk: " + this.imageFile);
                    }
                    this._dirty = false;
                }
            }
            catch (Throwable e) {
                String error = Constants.getMessageJMERR22(this.imageFile, LogFormatter.toString(e));
                JourneyMap.getLogger().severe(error);
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.mapType.name() + delim + this.imageFile.getPath() + delim + "image=" + (this._image == null ? "null" : "ok") + "dirty=" + this._dirty;
        }
    }
}

