/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;

public final class RGB {
    private final float[] frgb = new float[3];

    private RGB() {
    }

    public RGB(float red, float green, float blue) {
        this.frgb[0] = this.clamp(red);
        this.frgb[1] = this.clamp(green);
        this.frgb[1] = this.clamp(blue);
    }

    public RGB(Color original) {
        if (original == null) {
            throw new IllegalArgumentException("Color may not be null");
        }
        this.setFrom(original.getRGB());
    }

    public void setFrom(int newColor) {
        this.frgb[0] = (float)(newColor >> 16 & 0xFF) / 255.0f;
        this.frgb[1] = (float)(newColor >> 8 & 0xFF) / 255.0f;
        this.frgb[2] = (float)(newColor >> 0 & 0xFF) / 255.0f;
    }

    public static RGB average(Collection<RGB> colors) {
        RGB avg = new RGB();
        for (RGB color : colors) {
            avg.frgb[0] = avg.frgb[0] + color.frgb[0];
            avg.frgb[1] = avg.frgb[1] + color.frgb[1];
            avg.frgb[2] = avg.frgb[2] + color.frgb[2];
        }
        int count = colors.size();
        avg.frgb[0] = avg.frgb[0] / (float)count;
        avg.frgb[1] = avg.frgb[1] / (float)count;
        avg.frgb[2] = avg.frgb[2] / (float)count;
        return avg;
    }

    public void darken(float factor) {
        this.frgb[0] = this.clamp(this.frgb[0] * factor);
        this.frgb[1] = this.clamp(this.frgb[1] * factor);
        this.frgb[2] = this.clamp(this.frgb[2] * factor);
    }

    public void bevelSlope(float factor) {
        float bluer = factor < 1.0f ? 0.8f : 1.0f;
        this.frgb[0] = this.clamp(this.frgb[0] * bluer * factor);
        this.frgb[1] = this.clamp(this.frgb[1] * bluer * factor);
        this.frgb[2] = this.clamp(this.frgb[2] * factor);
    }

    public void moonlight(float factor) {
        this.frgb[0] = this.clamp(this.frgb[0] * factor);
        this.frgb[1] = this.clamp(this.frgb[1] * factor);
        this.frgb[2] = this.clamp(this.frgb[2] * (factor + 0.1f));
    }

    public void ghostSurface() {
        float factor = 0.4f;
        float[] hsb = Color.RGBtoHSB((int)((double)(this.frgb[0] * 255.0f) + 0.5), (int)((double)(this.frgb[1] * 255.0f) + 0.5), (int)((double)(this.frgb[2] * 255.0f) + 0.5), null);
        int grey = Color.HSBtoRGB(hsb[0], 0.0f, hsb[2]);
        this.setFrom(grey);
        this.frgb[0] = (this.frgb[0] + 0.5f) / 2.0f * 0.4f;
        this.frgb[1] = (this.frgb[1] + 0.5f) / 2.0f * 0.4f;
        this.frgb[2] = (this.frgb[2] + 0.6f) / 2.0f * 0.4f;
    }

    public Color toColor() {
        return new Color(this.frgb[0], this.frgb[1], this.frgb[2]);
    }

    private float clamp(float value) {
        return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RGB rgb = (RGB)o;
        return Arrays.equals(this.frgb, rgb.frgb);
    }

    public int hashCode() {
        return Arrays.hashCode(this.frgb);
    }
}

