/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.model.ChunkCoord;
import net.techbrew.journeymap.model.ChunkImageSet;
import net.techbrew.journeymap.model.ImageSet;
import net.techbrew.journeymap.model.RegionCoord;

public class RegionImageSet
extends ImageSet {
    Logger logger = JourneyMap.getLogger();
    protected final RegionCoord rCoord;

    public RegionImageSet(RegionCoord rCoord) {
        this.rCoord = rCoord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImageSet.Wrapper getWrapper(Constants.MapType mapType) {
        Object object = this.lock;
        synchronized (object) {
            ImageSet.Wrapper wrapper = (ImageSet.Wrapper)this.imageWrappers.get((Object)mapType);
            if (wrapper != null) {
                return wrapper;
            }
            BufferedImage image = null;
            File imageFile = null;
            imageFile = RegionImageHandler.getRegionImageFile(this.rCoord, mapType, false);
            boolean useLegacy = !imageFile.exists();
            image = RegionImageHandler.readRegionImage(imageFile, this.rCoord, 1, false, false);
            wrapper = this.addWrapper(mapType, imageFile, image);
            if (!useLegacy) {
                return wrapper;
            }
            File legacyFile = RegionImageHandler.getRegionImageFileLegacy(this.rCoord);
            if (legacyFile.exists()) {
                BufferedImage legacyImage = RegionImageHandler.readRegionImage(legacyFile, this.rCoord, 1, true, false);
                wrapper.setImage(this.getSubimage(this.rCoord, mapType, legacyImage));
                if (mapType == Constants.MapType.day) {
                    this.addWrapperFromLegacy(Constants.MapType.night, legacyImage);
                } else if (mapType == Constants.MapType.night) {
                    this.addWrapperFromLegacy(Constants.MapType.day, legacyImage);
                }
                this.addWrapper(Constants.MapType.OBSOLETE, legacyFile, null);
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChunk(ChunkImageSet cis, boolean forceFlush) {
        Object object = this.lock;
        synchronized (object) {
            for (ImageSet.Wrapper cisWrapper : cis.imageWrappers.values()) {
                this.insertChunk(cis.getCCoord(), cisWrapper.getImage(), cisWrapper.getMapType(), forceFlush);
            }
        }
    }

    protected void insertChunk(ChunkCoord cCoord, BufferedImage chunkImage, Constants.MapType mapType, boolean forceFlush) {
        ImageSet.Wrapper wrapper = this.getWrapper(mapType);
        boolean wasDirty = wrapper.isDirty();
        int x2 = this.rCoord.getXOffset(cCoord.chunkX);
        int z = this.rCoord.getZOffset(cCoord.chunkZ);
        BufferedImage subRegion = wrapper.getImage().getSubimage(x2, z, 16, 16);
        DataBuffer before = subRegion.getData().getDataBuffer();
        Graphics2D g2d = subRegion.createGraphics();
        g2d.drawImage((Image)chunkImage, 0, 0, null);
        g2d.dispose();
        DataBuffer after = subRegion.getData().getDataBuffer();
        long start = System.nanoTime();
        boolean dirty = forceFlush;
        if (!dirty) {
            boolean bl = dirty = before.getDataType() != after.getDataType() || before.getSize() != after.getSize() || before.getNumBanks() != after.getNumBanks();
        }
        if (!dirty) {
            if (before.getClass() != after.getClass()) {
                dirty = true;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Classes don't match: " + before.getClass() + " vs " + after.getClass());
                }
            } else {
                dirty = before instanceof DataBufferByte ? this.bufferChanged((DataBufferByte)before, (DataBufferByte)after) : (before instanceof DataBufferInt ? this.bufferChanged((DataBufferInt)before, (DataBufferInt)after) : true);
            }
        }
        if (dirty) {
            if (!wasDirty && this.logger.isLoggable(Level.FINER)) {
                long stop = System.nanoTime();
                this.logger.finer(this.rCoord + " dirty after chunk insert " + cCoord + ": " + dirty + ", compared in: " + TimeUnit.NANOSECONDS.toMicros(stop - start) + "micros");
            }
            wrapper.setDirty();
        }
    }

    private boolean bufferChanged(DataBufferInt before, DataBufferInt after) {
        boolean changed = false;
        for (int bank = 0; bank < after.getNumBanks(); ++bank) {
            int[] beforeBank;
            int[] afterBank = after.getData(bank);
            boolean bl = changed = !Arrays.equals(afterBank, beforeBank = before.getData(bank));
            if (changed) break;
        }
        return changed;
    }

    private boolean bufferChanged(DataBufferByte before, DataBufferByte after) {
        boolean changed = false;
        for (int bank = 0; bank < after.getNumBanks(); ++bank) {
            byte[] beforeBank;
            byte[] afterBank = after.getData(bank);
            boolean bl = changed = !Arrays.equals(afterBank, beforeBank = before.getData(bank));
            if (changed) break;
        }
        return changed;
    }

    public void loadLegacyNormal(File legacyFile) {
        if (!legacyFile.exists()) {
            throw new IllegalStateException("legacy file doesn't exist: " + legacyFile);
        }
        BufferedImage legacyImage = RegionImageHandler.getImage(legacyFile);
        this.addWrapperFromLegacy(Constants.MapType.day, legacyImage);
        this.addWrapperFromLegacy(Constants.MapType.night, legacyImage);
        this.addWrapper(Constants.MapType.OBSOLETE, legacyFile, null);
    }

    @Override
    public int hashCode() {
        return 31 * this.rCoord.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.rCoord.equals(((RegionImageSet)obj).rCoord);
    }

    protected BufferedImage getSubimage(RegionCoord rCoord, Constants.MapType mapType, BufferedImage image) {
        if (image == null) {
            return null;
        }
        switch (mapType) {
            case night: {
                return this.copyImage(image.getSubimage(512, 0, 512, 512));
            }
        }
        return this.copyImage(image.getSubimage(0, 0, 512, 512));
    }

    protected ImageSet.Wrapper addWrapperFromLegacy(Constants.MapType mapType, BufferedImage legacyImage) {
        BufferedImage image = this.getSubimage(this.rCoord, mapType, legacyImage);
        return this.addWrapper(mapType, image);
    }

    @Override
    protected ImageSet.Wrapper addWrapper(Constants.MapType mapType, BufferedImage image) {
        return this.addWrapper(new ImageSet.Wrapper(mapType, RegionImageHandler.getRegionImageFile(this.rCoord, mapType, false), image));
    }
}

