/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.awt.Color;
import java.util.LinkedHashMap;

public class Waypoint
extends LinkedHashMap<String, Object> {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_DEATH = 1;
    t location;

    public Waypoint(String name, int x2, int y, int z, boolean enable, int red, int green, int blue, int type, String origin, String display) {
        if (name == null) {
            name = "";
        }
        this.put(Key.id.name(), name + "_" + x2 + "_" + y + "_" + z);
        this.put(Key.name.name(), name);
        this.put(Key.x.name(), x2);
        this.put(Key.y.name(), y);
        this.put(Key.z.name(), z);
        this.put(Key.enable.name(), enable);
        this.put(Key.r.name(), red);
        this.put(Key.g.name(), green);
        this.put(Key.b.name(), blue);
        this.put(Key.type.name(), type);
        this.put(Key.origin.name(), origin);
        this.put(Key.display.name(), display);
        this.location = new t(x2, y, z);
    }

    public String getId() {
        return this.getString(Key.id);
    }

    public Object getObject(Key p) {
        return this.get(p.name());
    }

    public String getName() {
        return this.getString(Key.name);
    }

    public String getOrigin() {
        return this.getString(Key.origin);
    }

    public int getX() {
        return this.getInteger(Key.x);
    }

    public int getY() {
        return this.getInteger(Key.y);
    }

    public int getZ() {
        return this.getInteger(Key.z);
    }

    public int getType() {
        return this.getInteger(Key.type);
    }

    public boolean getEnable() {
        return this.getBoolean(Key.enable);
    }

    public Color getColor() {
        int r = this.getInteger(Key.r);
        int g = this.getInteger(Key.g);
        int b = this.getInteger(Key.b);
        return new Color(r, g, b);
    }

    public String getDisplay() {
        return this.getString(Key.display);
    }

    public t getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        return this.getDisplay();
    }

    Integer getInteger(Key p) {
        Object val = this.get(p.name());
        return val == null ? null : (Integer)val;
    }

    Boolean getBoolean(Key p) {
        Object val = this.get(p.name());
        return val == null ? null : (Boolean)val;
    }

    String getString(Key p) {
        Object val = this.get(p.name());
        return val == null ? null : (String)val;
    }

    public static enum Key {
        id,
        name,
        x,
        y,
        z,
        enable,
        r,
        g,
        b,
        dimension,
        type,
        origin,
        display;

    }
}

