/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.geom.Point2D;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DrawRotatedImageStep
implements DrawStep {
    final int posX;
    final int posZ;
    final TextureImpl texture;
    final float heading;

    public DrawRotatedImageStep(int posX, int posZ, TextureImpl texture, float heading) {
        this.posX = posX;
        this.posZ = posZ;
        this.texture = texture;
        this.heading = heading;
    }

    @Override
    public void draw(int xOffset, int yOffset, GridRenderer gridRenderer, float scale) {
        Point2D.Double pixel = gridRenderer.getPixel(this.posX, this.posZ);
        if (pixel != null) {
            DrawUtil.drawRotatedImage(this.texture, ((Point2D)pixel).getX() + (double)xOffset, ((Point2D)pixel).getY() + (double)yOffset, this.heading, scale);
        }
    }
}

