/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.Color;
import net.techbrew.journeymap.render.texture.TextureImpl;
import org.lwjgl.opengl.GL11;

public class DrawUtil {
    public static void drawCenteredLabel(String text, double x2, double y, Color bgColor, Color color, int alpha, double fontScale) {
        if (text == null || text.length() == 0) {
            return;
        }
        atv mc = atv.w();
        avi fontRenderer = mc.l;
        int width = fontRenderer.a(text);
        if (fontScale != 1.0) {
            GL11.glPushMatrix();
            x2 /= fontScale;
            y /= fontScale;
            GL11.glScaled((double)fontScale, (double)fontScale, (double)0.0);
        }
        if (bgColor != null) {
            float[] rgb = bgColor.getColorComponents(null);
            int rectWidth = width + fontRenderer.a(' ');
            int vMargin = 2;
            DrawUtil.drawRectangle(x2 - (double)(rectWidth / 2), y - 2.0, rectWidth, fontRenderer.a + 3, bgColor, alpha);
        }
        fontRenderer.a(text, (int)x2 - width / 2, (int)y, color.getRGB());
        if (fontScale != 1.0) {
            GL11.glPopMatrix();
        }
    }

    private static void drawQuad(TextureImpl texture, double x2, double y, int width, int height, boolean flip) {
        DrawUtil.drawQuad(texture, x2, y, width, height, null, 1.0f, flip, true, 770, 771);
    }

    private static void drawQuad(TextureImpl texture, double x2, double y, int width, int height, boolean flip, int glBlendSfactor, int glBlendDFactor) {
        DrawUtil.drawQuad(texture, x2, y, width, height, null, 1.0f, flip, true, glBlendSfactor, glBlendDFactor);
    }

    public static void drawQuad(TextureImpl texture, double x2, double y, int width, int height, Color color, float alpha, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor) {
        if (blend) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)glBlendSfactor, (int)glBlendDFactor);
            if (color != null) {
                float[] c = color.getColorComponents(null);
                GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)alpha);
            } else {
                GL11.glColor4f((float)alpha, (float)alpha, (float)alpha, (float)alpha);
            }
        }
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)texture.b());
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        int direction = flip ? -1 : 1;
        bfq tessellator = bfq.a;
        tessellator.b();
        tessellator.a(x2, (double)height + y, 0.0, 0.0, 1.0);
        tessellator.a(x2 + (double)width, (double)height + y, 0.0, (double)direction, 1.0);
        tessellator.a(x2 + (double)width, y, 0.0, (double)direction, 0.0);
        tessellator.a(x2, y, 0.0, 0.0, 0.0);
        tessellator.a();
        if (blend && (glBlendSfactor != 770 || glBlendDFactor != 771)) {
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    public static void drawRectangle(double x2, double y, int width, int height, Color color, int alpha) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        bfq tessellator = bfq.a;
        tessellator.b();
        tessellator.a(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        tessellator.a(x2, (double)height + y, 0.0, 0.0, 1.0);
        tessellator.a(x2 + (double)width, (double)height + y, 0.0, 1.0, 1.0);
        tessellator.a(x2 + (double)width, y, 0.0, 1.0, 0.0);
        tessellator.a(x2, y, 0.0, 0.0, 0.0);
        tessellator.a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public static void drawImage(TextureImpl texture, double x2, double y, boolean flip, float scale) {
        DrawUtil.drawQuad(texture, x2, y, (int)((float)texture.width * scale), (int)((float)texture.height * scale), flip);
    }

    public static void drawImage(TextureImpl texture, double x2, double y, boolean flip, int glBlendSfactor, int glBlendDfactor) {
        DrawUtil.drawQuad(texture, x2, y, texture.width, texture.height, flip, glBlendSfactor, glBlendDfactor);
    }

    public static void drawRotatedImage(TextureImpl texture, double x2, double y, float heading, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x2, (double)y, (double)0.0);
        GL11.glRotatef((float)heading, (float)0.0f, (float)0.0f, (float)1.0f);
        int width = (int)((float)texture.width * scale);
        int height = (int)((float)texture.height * scale);
        GL11.glTranslated((double)(-width), (double)(-height), (double)0.0);
        DrawUtil.drawQuad(texture, width / 2, height / 2, width, height, false);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawColoredImage(TextureImpl texture, int alpha, Color color, double x2, double y) {
        DrawUtil.drawQuad(texture, x2, y, texture.width, texture.height, color, alpha, false, true, 770, 771);
    }

    public static void drawColoredImage(TextureImpl texture, int alpha, Color color, double x2, double y, boolean blend) {
        DrawUtil.drawQuad(texture, x2, y, texture.width, texture.height, color, alpha, false, false, 0, 0);
    }

    public static void drawEntity(double x2, double y, Double heading, boolean flipInsteadOfRotate, TextureImpl texture, int bottomMargin, float scale) {
        if (heading == null) {
            DrawUtil.drawImage(texture, x2, y, false, scale);
        } else if (!flipInsteadOfRotate) {
            DrawUtil.drawRotatedImage(texture, x2, y, heading.floatValue(), scale);
        } else {
            boolean flip = heading < 90.0;
            int width = (int)((float)texture.width * scale);
            int height = (int)((float)texture.height * scale);
            DrawUtil.drawImage(texture, x2 - (double)(width / 2), y - (double)(height / 2) - (double)bottomMargin, flip, scale);
        }
    }
}

