/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import com.google.common.cache.Cache;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.Tile;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.render.overlay.TilePos;
import net.techbrew.journeymap.render.texture.TextureImpl;
import org.lwjgl.opengl.GL11;

public class GridRenderer {
    private final Logger logger = JourneyMap.getLogger();
    private final boolean debug = this.logger.isLoggable(Level.FINE);
    private final TreeMap<TilePos, Integer> grid = new TreeMap();
    private final int gridSize;
    final double srcSize;
    final Cache<Integer, Tile> tc = TileCache.instance();
    final TilePos centerPos = new TilePos(0, 0);
    private Point2D viewPortOrigin;
    private int viewPortSize;
    private int lastHeight = -1;
    private int lastWidth = -1;
    private int centerTileHash = Integer.MIN_VALUE;
    private int zoom;
    private double centerBlockX;
    private double centerBlockZ;
    private final Color bgColor = new Color(34, 34, 34);
    private final Point2D.Double centerPixelOffset = new Point2D.Double();
    private TextureImpl crosshairs;
    private Integer dimension;
    private File worldDir;

    public GridRenderer(int gridSize) {
        this.gridSize = gridSize;
        this.srcSize = gridSize * 512;
    }

    public void setViewPort(Point2D origin, int size) {
        this.viewPortOrigin = origin;
        this.viewPortSize = size;
    }

    private void populateGrid(Tile centerTile) {
        int endRow = (this.gridSize - 1) / 2;
        int endCol = (this.gridSize - 1) / 2;
        int startRow = -endRow;
        int startCol = -endCol;
        Cache<Integer, Tile> tc = TileCache.instance();
        for (int z = startRow; z <= endRow; ++z) {
            for (int x2 = startCol; x2 <= endCol; ++x2) {
                TilePos pos = new TilePos(x2, z);
                Tile tile = this.findNeighbor(centerTile, pos);
                this.grid.put(pos, tile.hashCode());
            }
        }
    }

    public void move(int deltaBlockX, int deltaBlockZ) {
        this.center(this.centerBlockX + (double)deltaBlockX, this.centerBlockZ + (double)deltaBlockZ, this.zoom);
    }

    public boolean center() {
        return this.center(this.centerBlockX, this.centerBlockZ, this.zoom);
    }

    public boolean hasTile(Tile tile) {
        return this.grid.containsValue(tile);
    }

    public boolean center(double blockX, double blockZ, int zoom) {
        int tileZ;
        if (blockX == this.centerBlockX && blockZ == this.centerBlockZ && zoom == this.zoom && !this.grid.isEmpty()) {
            return false;
        }
        this.centerBlockX = blockX;
        this.centerBlockZ = blockZ;
        this.zoom = zoom;
        int tileX = Tile.blockPosToTile((int)Math.floor(this.centerBlockX), this.zoom);
        int newCenterHash = Tile.toHashCode(tileX, tileZ = Tile.blockPosToTile((int)Math.floor(this.centerBlockZ), this.zoom), zoom, this.dimension);
        boolean centerTileChanged = newCenterHash != this.centerTileHash;
        this.centerTileHash = newCenterHash;
        if (centerTileChanged || this.grid.isEmpty()) {
            Tile newCenterTile = this.findTile(tileX, tileZ);
            this.populateGrid(newCenterTile);
            if (this.debug) {
                this.logger.fine("Centered on " + newCenterTile + " with pixel offsets of " + this.centerPixelOffset.x + "," + this.centerPixelOffset.y);
                atv mc = atv.w();
                BufferedImage tmp = new BufferedImage(mc.d, mc.e, 2);
                Graphics2D g = tmp.createGraphics();
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(Color.GREEN);
                g.drawLine(mc.d / 2, 0, mc.d / 2, mc.e);
                g.drawLine(0, mc.e / 2, mc.d, mc.e / 2);
                if (this.crosshairs != null) {
                    this.crosshairs.deleteTexture();
                }
                this.crosshairs = new TextureImpl(tmp);
            }
        }
        return true;
    }

    public boolean updateTextures(Constants.MapType mapType, Integer vSlice, int width, int height, boolean fullUpdate, double xOffset, double yOffset) {
        this.lastWidth = width;
        this.lastHeight = height;
        Integer centerHash = this.grid.get(this.centerPos);
        if (centerHash == null) {
            return false;
        }
        Tile centerTile = (Tile)this.tc.getIfPresent((Object)centerHash);
        if (centerTile == null) {
            int tileX = Tile.blockPosToTile((int)Math.floor(this.centerBlockX), this.zoom);
            int tileZ = Tile.blockPosToTile((int)Math.floor(this.centerBlockZ), this.zoom);
            centerTile = this.findTile(tileX, tileZ);
            this.populateGrid(centerTile);
        }
        Point2D blockPixelOffset = centerTile.blockPixelOffsetInTile(this.centerBlockX, this.centerBlockZ);
        double blockSizeOffset = Math.pow(2.0, this.zoom) / 2.0;
        int magic = (this.gridSize == 5 ? 2 : 1) * 512;
        double displayOffsetX = xOffset + (double)magic - (this.srcSize - (double)this.lastWidth) / 2.0;
        displayOffsetX = this.centerBlockX < 0.0 ? (displayOffsetX -= blockSizeOffset) : (displayOffsetX += blockSizeOffset);
        double displayOffsetY = yOffset + (double)magic - (this.srcSize - (double)this.lastHeight) / 2.0;
        displayOffsetY = this.centerBlockZ < 0.0 ? (displayOffsetY -= blockSizeOffset) : (displayOffsetY += blockSizeOffset);
        this.centerPixelOffset.setLocation(displayOffsetX + blockPixelOffset.getX(), displayOffsetY + blockPixelOffset.getY());
        if (!fullUpdate) {
            return false;
        }
        boolean updated = false;
        for (Map.Entry<TilePos, Integer> entry : this.grid.entrySet()) {
            TilePos pos = entry.getKey();
            Integer hashCode = entry.getValue();
            Tile tile = (Tile)this.tc.getIfPresent((Object)hashCode);
            if (tile == null) {
                tile = this.findNeighbor(centerTile, pos);
                this.grid.put(pos, tile.hashCode());
            }
            if (!tile.updateTexture(pos, mapType, vSlice)) continue;
            updated = true;
        }
        return updated;
    }

    public Point2D.Double getCenterPixelOffset() {
        return this.centerPixelOffset;
    }

    public Point2D.Double getBlockPixelInGrid(double x2, double z) {
        double localBlockX = x2 - this.centerBlockX;
        double localBlockZ = z - this.centerBlockZ;
        int blockSize = (int)Math.pow(2.0, this.zoom);
        double blockSizeOffset = (double)blockSize / 2.0;
        double pixelOffsetX = (double)(this.lastWidth / 2) + localBlockX * (double)blockSize;
        double pixelOffsetZ = (double)(this.lastHeight / 2) + localBlockZ * (double)blockSize;
        Point2D.Double p = new Point2D.Double();
        p.setLocation(pixelOffsetX, pixelOffsetZ);
        return p;
    }

    public void draw(List<DrawStep> drawStepList, int xOffset, int yOffset, float scale) {
        if (drawStepList == null || drawStepList.isEmpty()) {
            return;
        }
        this.draw(xOffset, yOffset, scale, drawStepList.toArray(new DrawStep[drawStepList.size()]));
    }

    public void draw(int xOffset, int yOffset, float scale, DrawStep ... drawSteps) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        for (DrawStep drawStep : drawSteps) {
            drawStep.draw(xOffset, yOffset, this, scale);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    public void draw(float opacity, double offsetX, double offsetZ) {
        if (!this.grid.isEmpty()) {
            double centerX = offsetX + this.centerPixelOffset.x;
            double centerZ = offsetZ + this.centerPixelOffset.y;
            Cache<Integer, Tile> tc = TileCache.instance();
            for (Map.Entry<TilePos, Integer> entry : this.grid.entrySet()) {
                Tile tile = (Tile)tc.getIfPresent((Object)entry.getValue());
                if (tile == null) continue;
                this.drawTile(entry.getKey(), tile, centerX, centerZ);
            }
            if (this.debug && this.crosshairs != null) {
                atv mc = atv.w();
                GL11.glBindTexture((int)3553, (int)this.crosshairs.b());
                bfq tessellator = bfq.a;
                tessellator.b();
                tessellator.a(0.0, (double)mc.e, 0.0, 0.0, 1.0);
                tessellator.a((double)mc.d, (double)mc.e, 0.0, 1.0, 1.0);
                tessellator.a((double)mc.d, 0.0, 0.0, 1.0, 0.0);
                tessellator.a(0.0, 0.0, 0.0, 0.0, 0.0);
                tessellator.a();
            }
        }
    }

    private void drawTile(TilePos pos, Tile tile, double offsetX, double offsetZ) {
        double startX = offsetX + pos.startX;
        double startZ = offsetZ + pos.startZ;
        double endX = offsetX + pos.endX;
        double endZ = offsetZ + pos.endZ;
        DrawUtil.drawRectangle(startX, startZ, 512, 512, this.bgColor, 255);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (tile.hasTexture()) {
            GL11.glEnable((int)3553);
            GL11.glBindTexture((int)3553, (int)tile.getTexture().b());
            bfq tessellator = bfq.a;
            tessellator.b();
            tessellator.a(startX, endZ, 0.0, 0.0, 1.0);
            tessellator.a(endX, endZ, 0.0, 1.0, 1.0);
            tessellator.a(endX, startZ, 0.0, 1.0, 0.0);
            tessellator.a(startX, startZ, 0.0, 0.0, 0.0);
            tessellator.a();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    private boolean isOnScreen(TilePos pos) {
        return this.isOnScreen(pos.startX + this.centerPixelOffset.x, pos.startZ + this.centerPixelOffset.y, pos.endX + this.centerPixelOffset.x, pos.endZ + this.centerPixelOffset.y);
    }

    public Point2D.Double getPixel(double blockX, double blockZ) {
        Point2D.Double pixel = this.getBlockPixelInGrid(blockX, blockZ);
        if (this.isOnScreen(pixel)) {
            return pixel;
        }
        return null;
    }

    public Point2D.Double getClosestOnscreenBlock(int blockX, int blockZ) {
        Point2D.Double pixel = this.getBlockPixelInGrid(blockX, blockZ);
        if (pixel.getX() < 0.0) {
            pixel.setLocation(0.0, pixel.getY());
        } else if (pixel.getX() > (double)this.lastWidth) {
            pixel.setLocation(this.lastWidth, pixel.getY());
        }
        if (pixel.getY() < 0.0) {
            pixel.setLocation(pixel.getX(), 0.0);
        } else if (pixel.getY() > (double)this.lastHeight) {
            pixel.setLocation(pixel.getX(), this.lastHeight);
        }
        return pixel;
    }

    public void ensureOnScreen(Point2D pixel) {
        if (pixel.getX() < 0.0) {
            pixel.setLocation(0.0, pixel.getY());
        } else if (pixel.getX() > (double)this.lastWidth) {
            pixel.setLocation(this.lastWidth, pixel.getY());
        }
        if (pixel.getY() < 0.0) {
            pixel.setLocation(pixel.getX(), 0.0);
        } else if (pixel.getY() > (double)this.lastHeight) {
            pixel.setLocation(pixel.getX(), this.lastHeight);
        }
    }

    public boolean isOnScreen(Point2D.Double pixel) {
        return pixel.getX() > 0.0 && pixel.getX() < (double)this.lastWidth && pixel.getY() > 0.0 && pixel.getY() < (double)this.lastHeight;
    }

    public boolean isOnScreen(double x2, double y) {
        return x2 > 0.0 && x2 < (double)this.lastWidth && y > 0.0 && y < (double)this.lastHeight;
    }

    public boolean isOnScreen(double startX, double startY, double endX, double endY) {
        return endX > 0.0 && startX < (double)this.lastWidth && endY > 0.0 && startY < (double)this.lastHeight;
    }

    private Tile findNeighbor(Tile tile, TilePos pos) {
        if (pos.deltaX == 0 && pos.deltaZ == 0) {
            return tile;
        }
        return this.findTile(tile.tileX + pos.deltaX, tile.tileZ + pos.deltaZ);
    }

    private Tile findTile(int tileX, int tileZ) {
        return TileCache.getOrCreate(this.worldDir, tileX, tileZ, this.zoom, this.dimension);
    }

    public void setContext(File worldDir, int dimension) {
        this.worldDir = worldDir;
        this.dimension = dimension;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean setZoom(int zoom) {
        return this.center(this.centerBlockX, this.centerBlockZ, zoom);
    }

    public int getRenderSize() {
        return this.gridSize * 512;
    }

    public void clear() {
        this.grid.clear();
    }
}

