/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.overlay.TilePos;
import net.techbrew.journeymap.render.texture.DelayedTexture;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class Tile {
    public static final int TILESIZE = 512;
    final int dimension;
    final int zoom;
    final int tileX;
    final int tileZ;
    final File worldDir;
    final abp ulChunk;
    final abp lrChunk;
    final Point ulBlock;
    final Point lrBlock;
    long lastImageTime = 0L;
    Integer lastVSlice;
    Constants.MapType lastMapType;
    Future<DelayedTexture> futureTex;
    TextureImpl textureImpl;
    private final Logger logger = JourneyMap.getLogger();
    private final boolean debug = this.logger.isLoggable(Level.FINE);

    public Tile(File worldDir, int tileX, int tileZ, int zoom, int dimension) {
        this.worldDir = worldDir;
        this.tileX = tileX;
        this.tileZ = tileZ;
        this.zoom = zoom;
        this.dimension = dimension;
        int distance = 32 / (int)Math.pow(2.0, zoom);
        this.ulChunk = new abp(tileX * distance, tileZ * distance);
        this.lrChunk = new abp(this.ulChunk.a + distance - 1, this.ulChunk.b + distance - 1);
        this.ulBlock = new Point(this.ulChunk.a * 16, this.ulChunk.b * 16);
        this.lrBlock = new Point(this.lrChunk.a * 16 + 15, this.lrChunk.b * 16 + 15);
    }

    public boolean updateTexture(TilePos pos, Constants.MapType mapType, Integer vSlice) {
        if (this.futureTex == null) {
            this.lastMapType = mapType;
            this.lastVSlice = vSlice;
            Integer glId = null;
            BufferedImage image = null;
            if (this.textureImpl != null) {
                glId = this.textureImpl.b();
                image = this.textureImpl.getImage();
            }
            this.futureTex = TextureCache.instance().prepareImage(glId, image, this.worldDir, this.ulChunk, this.lrChunk, mapType, vSlice, this.dimension, true, 512, 512);
            return true;
        }
        return false;
    }

    public boolean hasTexture() {
        if (this.textureImpl != null) {
            return true;
        }
        if (this.futureTex != null && this.futureTex.isDone()) {
            try {
                if (this.futureTex.get() == null) {
                    this.futureTex = null;
                    this.lastImageTime = 0L;
                    return false;
                }
                return true;
            }
            catch (Throwable e) {
                this.logger.severe(LogFormatter.toString(e));
            }
        }
        return false;
    }

    public TextureImpl getTexture() {
        if (this.futureTex != null && this.futureTex.isDone()) {
            try {
                DelayedTexture dt = this.futureTex.get();
                if (dt != null) {
                    TextureImpl texture = dt.bindTexture();
                    if (this.textureImpl == null) {
                        this.textureImpl = texture;
                    }
                }
                this.futureTex = null;
            }
            catch (Throwable e) {
                this.logger.severe(LogFormatter.toString(e));
            }
        }
        return this.textureImpl;
    }

    public void clear() {
        if (this.textureImpl != null) {
            this.textureImpl.deleteTexture();
            this.textureImpl = null;
        }
    }

    public String toString() {
        return "Tile [ " + this.tileX + "," + this.tileZ + " (zoom " + this.zoom + ") ]";
    }

    public int hashCode() {
        return Tile.toHashCode(this.tileX, this.tileZ, this.zoom, this.dimension);
    }

    public static int blockPosToTile(int b, int zoom) {
        int tile = b >> 9 - zoom;
        return tile;
    }

    private String blockBounds() {
        return this.ulBlock.x + "," + this.ulBlock.y + " - " + this.lrBlock.x + "," + this.lrBlock.y;
    }

    private int tileToBlock(int t2) {
        return t2 << 9 - this.zoom;
    }

    public static int tileToBlock(int t2, int zoom) {
        return t2 << 9 - zoom;
    }

    public Point2D blockPixelOffsetInTile(double x2, double z) {
        if (x2 < (double)this.ulBlock.x || Math.floor(x2) > (double)this.lrBlock.x || z < (double)this.ulBlock.y || Math.floor(z) > (double)this.lrBlock.y) {
            throw new RuntimeException("Block " + x2 + "," + z + " isn't in " + this);
        }
        double localBlockX = (double)this.ulBlock.x - x2;
        if (x2 < 0.0) {
            localBlockX += 1.0;
        }
        double localBlockZ = (double)this.ulBlock.y - z;
        if (z < 0.0) {
            localBlockZ += 1.0;
        }
        int blockSize = (int)Math.pow(2.0, this.zoom);
        double pixelOffsetX = 256.0 + localBlockX * (double)blockSize - (double)(blockSize / 2);
        double pixelOffsetZ = 256.0 + localBlockZ * (double)blockSize - (double)(blockSize / 2);
        return new Point2D.Double(pixelOffsetX, pixelOffsetZ);
    }

    public static int toHashCode(int tileX, int tileZ, int zoom, int dimension) {
        int prime = 31;
        int result = 1;
        result = 31 * result + tileX;
        result = 31 * result + tileZ;
        result = 31 * result + zoom;
        result = 31 * result + dimension;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tile other = (Tile)obj;
        if (this.tileX != other.tileX) {
            return false;
        }
        if (this.tileZ != other.tileZ) {
            return false;
        }
        if (this.zoom != other.zoom) {
            return false;
        }
        if (this.dimension != other.dimension) {
            return false;
        }
        return this.worldDir.equals(other.worldDir);
    }

    protected void finalize() {
        try {
            if (JourneyMap.getInstance().isMapping().booleanValue() && this.textureImpl != null) {
                this.logger.warning("Tile wasn't cleared before finalize() called: " + this);
                this.clear();
            }
        }
        catch (NullPointerException e) {
        }
        catch (Throwable t2) {
            this.logger.severe(t2.getMessage());
        }
    }
}

