/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.texture;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.render.texture.TextureImpl;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DelayedTexture {
    Integer glId;
    BufferedImage image;
    final int width;
    final int height;
    final ByteBuffer buffer;

    public DelayedTexture(Integer glId, BufferedImage image, String debugString) {
        this.glId = glId;
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        if (debugString != null) {
            Graphics2D g = RegionImageHandler.initRenderingHints(image.createGraphics());
            g.setPaint(Color.WHITE);
            g.setStroke(new BasicStroke(3.0f));
            g.drawRect(0, 0, image.getWidth(), image.getHeight());
            Font labelFont = new Font("Arial", 1, 16);
            g.setFont(labelFont);
            g.drawString(debugString, 16, 16);
            g.dispose();
        }
        int[] pixels = new int[this.width * this.height];
        image.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        this.buffer = BufferUtils.createByteBuffer((int)(this.width * this.height * 4));
        for (int y = 0; y < this.height; ++y) {
            for (int x2 = 0; x2 < this.width; ++x2) {
                int pixel = pixels[y * this.width + x2];
                this.buffer.put((byte)(pixel >> 16 & 0xFF));
                this.buffer.put((byte)(pixel >> 8 & 0xFF));
                this.buffer.put((byte)(pixel & 0xFF));
                this.buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        this.buffer.flip();
    }

    public TextureImpl bindTexture() {
        if (this.glId == null) {
            this.glId = bip.a();
        }
        GL11.glBindTexture((int)3553, (int)this.glId);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
        return new TextureImpl(this.glId, this.image);
    }
}

