/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.server.BaseService;
import se.rupy.http.Event;

public class FileService
extends BaseService {
    private static final long serialVersionUID = 2L;
    private String resourcePath;
    private boolean useZipEntry;
    private File zipFile;

    public FileService() {
        URL resourceDir = JourneyMap.class.getResource("/assets/journeymap/web");
        if (resourceDir == null) {
            JourneyMap.getLogger().severe("Can't determine path to webroot!");
        } else {
            this.resourcePath = resourceDir.getPath();
            if (this.resourcePath.endsWith("/")) {
                this.resourcePath = this.resourcePath.substring(0, this.resourcePath.length() - 1);
            }
            this.useZipEntry = (resourceDir.getProtocol().equals("file") || resourceDir.getProtocol().equals("jar")) && this.resourcePath.contains("!/");
        }
    }

    @Override
    public String path() {
        return null;
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        String path = null;
        InputStream in = null;
        try {
            String requestPath = null;
            path = event.query().path();
            if (path.startsWith("/skin/")) {
                this.serveSkin(path.split("/skin/")[1], event);
                return;
            }
            requestPath = "/".equals(path) ? this.resourcePath + "/index.html" : this.resourcePath + path;
            if (this.useZipEntry) {
                ZipEntry zipEntry;
                String[] tokens = requestPath.split("file:")[1].split("!/");
                if (this.zipFile == null) {
                    this.zipFile = new File(URI.create(tokens[0]).getPath());
                    if (!this.zipFile.canRead()) {
                        throw new RuntimeException("Can't read Zip file: " + this.zipFile + " (originally: " + tokens[0] + ")");
                    }
                }
                String innerName = tokens[1];
                Object dest = null;
                FileInputStream fis = new FileInputStream(this.zipFile);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                boolean found = false;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    if (!innerName.equals(zipEntry.getName())) continue;
                    in = new ZipFile(this.zipFile).getInputStream(zipEntry);
                    BaseService.ResponseHeader.on(event).content(zipEntry);
                    this.serveStream(in, event);
                    found = true;
                    break;
                }
                zis.close();
                fis.close();
                if (!found) {
                    JourneyMap.getLogger().severe("zipEntry not found: " + zipEntry + " in " + this.zipFile);
                    this.throwEventException(404, Constants.getMessageJMERR13(requestPath), event, true);
                }
            } else {
                File file = new File(requestPath);
                if (file.exists()) {
                    this.serveFile(file, event);
                } else {
                    JourneyMap.getLogger().severe("Directory not found: " + requestPath);
                    this.throwEventException(404, Constants.getMessageJMERR13(requestPath), event, true);
                }
            }
        }
        catch (Event eventEx) {
            throw eventEx;
        }
        catch (Throwable t2) {
            JourneyMap.getLogger().severe(LogFormatter.toString(t2));
            this.throwEventException(500, Constants.getMessageJMERR12(path), event, true);
        }
    }

    public void serveSkin(String username, Event event) throws Exception {
        BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png);
        TextureImpl tex = TextureCache.instance().getPlayerSkin(username);
        BufferedImage img = tex.getImage();
        if (img != null) {
            this.serveImage(event, img);
        } else {
            event.reply().code("404 Not Found");
        }
    }

    public void serveFile(File sourceFile, Event event) throws Event, IOException {
        BaseService.ResponseHeader.on(event).content(sourceFile);
        this.serveStream(new FileInputStream(sourceFile), event);
    }

    public void serveStream(InputStream input, Event event) throws Event, IOException {
        ReadableByteChannel inputChannel = null;
        WritableByteChannel outputChannel = null;
        try {
            inputChannel = Channels.newChannel(input);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            GZIPOutputStream output = new GZIPOutputStream(bout);
            outputChannel = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            while (inputChannel.read(buffer) != -1) {
                buffer.flip();
                outputChannel.write(buffer);
                buffer.clear();
            }
            output.flush();
            output.close();
            bout.close();
            byte[] gzbytes = bout.toByteArray();
            BaseService.ResponseHeader.on(event).contentLength(gzbytes.length).setHeader("Content-encoding", "gzip");
            event.output().write(gzbytes);
        }
        catch (IOException e) {
            JourneyMap.getLogger().severe(LogFormatter.toString(e));
            throw event;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    @Override
    protected byte[] gzip(String data) {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            GZIPOutputStream output = new GZIPOutputStream(bout);
            output.write(data.getBytes());
            output.flush();
            output.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception ex) {
            JourneyMap.getLogger().warning("Failed to gzip encode: " + data);
            return null;
        }
    }
}

