/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import java.net.URLEncoder;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.JsonHelper;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.server.BaseService;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class PropertyService
extends BaseService {
    private static final long serialVersionUID = 4412225358529161454L;
    public static final String CALLBACK_PARAM = "callback";

    @Override
    public String path() {
        return "/properties";
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        Query query = event.query();
        query.parse();
        String path = query.path();
        if (query.method() == 2) {
            this.post(event);
            return;
        }
        if (query.method() != 1) {
            throw new Exception("HTTP method not allowed");
        }
        StringBuffer jsonData = new StringBuffer();
        boolean useJsonP = query.containsKey(CALLBACK_PARAM);
        if (useJsonP) {
            jsonData.append(URLEncoder.encode(query.get(CALLBACK_PARAM).toString(), UTF8.name()));
            jsonData.append("(");
        } else {
            jsonData.append("data=");
        }
        jsonData.append(JsonHelper.toJson(PropertyManager.getInstance().getProperties()));
        if (useJsonP) {
            jsonData.append(")");
            BaseService.ResponseHeader.on(event).noCache().contentType(BaseService.ContentType.jsonp);
        }
        this.gzipResponse(event, jsonData.toString());
    }

    public void post(Event event) throws Exception {
        Query query = event.query();
        String[] param = query.parameters().split("=");
        if (param.length != 2) {
            throw new Exception("Expected single key-value pair");
        }
        PropertyManager pm = PropertyManager.getInstance();
        PropertyManager.Key key = PropertyManager.Key.lookup(param[0]);
        if (key == null) {
            throw new Exception("Unknown property key: " + param[0]);
        }
        pm.setProperty(key, param[1]);
        JourneyMap.getLogger().finer("Updated property: " + param[0] + "=" + param[1]);
    }
}

