/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.server.BaseService;
import net.techbrew.journeymap.server.FileService;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class TileService
extends FileService {
    private static final long serialVersionUID = 4412225358529161454L;
    public static final String CALLBACK_PARAM = "callback";
    public static final String CHARACTER_ENCODING = "UTF-8";
    private byte[] blankImage;

    @Override
    public String path() {
        return "/tile";
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        File worldDir;
        long start = System.currentTimeMillis();
        Query query = event.query();
        query.parse();
        atv minecraft = atv.w();
        bdd theWorld = minecraft.f;
        if (theWorld == null) {
            this.throwEventException(503, Constants.getMessageJMERR09(new Object[0]), event, false);
        }
        if (!JourneyMap.getInstance().isMapping().booleanValue()) {
            this.throwEventException(503, Constants.getMessageJMERR02(new Object[0]), event, false);
        }
        if (!(worldDir = FileHandler.getJMWorldDir(minecraft)).exists() || !worldDir.isDirectory()) {
            String error = Constants.getMessageJMERR06("worldDir=" + worldDir.getAbsolutePath());
            this.throwEventException(400, error, event, true);
        }
        try {
            int zoom = this.getParameter((Map<String, String[]>)query, "zoom", 0);
            int x2 = this.getParameter((Map<String, String[]>)query, "x", 0);
            Integer vSlice = this.getParameter((Map<String, String[]>)query, "depth", (Integer)null);
            int z = this.getParameter((Map<String, String[]>)query, "z", 0);
            int dimension = this.getParameter((Map<String, String[]>)query, "dim", 0);
            String mapTypeString = this.getParameter(query, "mapType", Constants.MapType.day.name());
            Constants.MapType mapType = null;
            try {
                mapType = Constants.MapType.valueOf(mapTypeString);
            }
            catch (Exception e) {
                String error = Constants.getMessageJMERR05("mapType=" + (Object)((Object)mapType));
                this.throwEventException(400, error, event, true);
            }
            if (mapType != Constants.MapType.underground) {
                vSlice = null;
            }
            if (mapType == Constants.MapType.underground && WorldData.isHardcoreAndMultiplayer()) {
                BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png).noCache();
                this.serveFile(RegionImageHandler.getBlank512x512ImageFile(), event);
            } else {
                int scale = (int)Math.pow(2.0, zoom);
                int distance = 32 / scale;
                int minChunkX = x2 * distance;
                int minChunkZ = z * distance;
                int maxChunkX = minChunkX + distance - 1;
                int maxChunkZ = minChunkZ + distance - 1;
                abp startCoord = new abp(minChunkX, minChunkZ);
                abp endCoord = new abp(maxChunkX, maxChunkZ);
                BufferedImage img = RegionImageHandler.getMergedChunks(worldDir, startCoord, endCoord, mapType, vSlice, dimension, true, null, 512, 512, false);
                BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png).noCache();
                this.serveImage(event, img);
            }
            long stop = System.currentTimeMillis();
            if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                JourneyMap.getLogger().fine(stop - start + "ms to serve tile");
            }
        }
        catch (NumberFormatException e) {
            this.reportMalformedRequest(event);
        }
    }
}

