/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task;

import java.io.File;
import java.io.FileFilter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.Utils;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageSet;
import net.techbrew.journeymap.task.IGenericTask;
import net.techbrew.journeymap.task.ITask;
import net.techbrew.journeymap.task.ITaskManager;

public class LegacyMigrationTask
implements IGenericTask {
    final int mapTaskDelay = PropertyManager.getInstance().getInteger(PropertyManager.Key.UPDATETIMER_CHUNKS);
    private static final Logger logger = JourneyMap.getLogger();
    final abw world;
    final File jmWorldDir;
    final Stack<File> pngFiles;
    final int pngFilesFound;

    private LegacyMigrationTask(atv minecraft, File jmWorldDir, Stack<File> pngFiles, int pngFilesFound) {
        this.world = minecraft.f;
        this.jmWorldDir = jmWorldDir;
        this.pngFiles = pngFiles;
        this.pngFilesFound = pngFilesFound;
    }

    @Override
    public void performTask() {
        float total = 1.0f * (float)this.pngFilesFound;
        float remaining = total - (float)this.pngFiles.size();
        String percent = new DecimalFormat("##.#").format(remaining * 100.0f / total) + "%";
        ChatLog.announceI18N("JourneyMap.file_updates", percent);
        long start = System.nanoTime();
        int count = 0;
        long elapsed = 0L;
        while (!this.pngFiles.isEmpty()) {
            File png = this.pngFiles.pop();
            if (!png.exists()) continue;
            String fileName = png.getName();
            try {
                if (!png.canRead()) {
                    this.processJunk(png);
                } else if (fileName.contains("_Normal.")) {
                    this.processNormal(png);
                } else if (fileName.contains("_Cave.")) {
                    this.processUnderground(png, 0);
                } else if (fileName.contains("_Nether.")) {
                    this.processUnderground(png, -1);
                } else if (fileName.contains("_End.")) {
                    this.processUnderground(png, 1);
                } else {
                    this.processJunk(png);
                }
            }
            catch (Exception e) {
                logger.warning("Problem processing " + fileName + ": " + e);
                this.processJunk(png);
            }
            ++count;
            elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            if (elapsed <= (long)this.mapTaskDelay) continue;
        }
        logger.info("Processed " + count + " legacy images in " + elapsed + "ms");
    }

    private void processNormal(File file) {
        String[] coords = file.getName().split("_")[0].split(",");
        if (coords.length != 2) {
            this.processJunk(file);
        } else {
            int regionX = Integer.parseInt(coords[0]);
            int regionZ = Integer.parseInt(coords[1]);
            RegionCoord rc = new RegionCoord(this.jmWorldDir, regionX, null, regionZ, 0);
            RegionImageSet ris = new RegionImageSet(rc);
            ris.loadLegacyNormal(file);
            ris.writeToDisk(true);
        }
    }

    private void processUnderground(File file, int dimension) {
        String[] coords = file.getName().split("_")[0].split(",");
        if (coords.length != 3) {
            this.processJunk(file);
        } else {
            int regionX = Integer.parseInt(coords[0]);
            int regionZ = Integer.parseInt(coords[1]);
            int regionY = Integer.parseInt(coords[2]);
            RegionCoord rCoord = new RegionCoord(this.jmWorldDir, regionX, regionY, regionZ, dimension);
            RegionImageHandler.getInstance();
            File newFile = RegionImageHandler.getRegionImageFile(rCoord, Constants.MapType.underground, false);
            if (newFile.exists()) {
                newFile.delete();
            } else {
                newFile.getParentFile().mkdirs();
            }
            boolean moved = file.renameTo(newFile);
            if (!moved) {
                this.processJunk(file);
            }
        }
    }

    private void processJunk(File file) {
        try {
            File junkDir = new File(this.jmWorldDir, "junk");
            if (junkDir.exists()) {
                if (!junkDir.isDirectory()) {
                    junkDir.delete();
                    junkDir.mkdirs();
                }
            } else {
                junkDir.mkdirs();
            }
            int count = 1;
            File junkFile = new File(junkDir, file.getName());
            while (junkFile.exists()) {
                junkFile = new File(junkDir, file.getName() + "_" + count++ + ".png");
            }
            boolean moved = file.renameTo(junkFile);
            if (!moved) {
                logger.warning("Couldn't move to junk folder: " + file);
            } else {
                logger.warning("Junked file: " + file);
            }
        }
        catch (Exception e) {
            logger.warning("Couldn't move to junk folder: " + file);
        }
    }

    static class PngFileFilter
    implements FileFilter {
        PngFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".png");
        }
    }

    public static class Manager
    implements ITaskManager {
        boolean enabled;
        File jmWorldDir;
        long worldHash;
        Stack<File> pngFiles;
        int pngFilesFound;

        @Override
        public Class<? extends ITask> getTaskClass() {
            return LegacyMigrationTask.class;
        }

        @Override
        public boolean enableTask(atv minecraft, Object params) {
            this.jmWorldDir = FileHandler.getJMWorldDir(minecraft, Utils.getWorldHash(minecraft));
            File[] files = this.jmWorldDir.listFiles(new PngFileFilter());
            if (files.length > 0) {
                this.pngFiles = new Stack();
                this.pngFiles.addAll(Arrays.asList(files));
                this.pngFilesFound = this.pngFiles.size();
                this.enabled = true;
            } else {
                logger.info("No legacy files found.");
                this.enabled = false;
            }
            return this.enabled;
        }

        @Override
        public boolean isEnabled(atv minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(atv minecraft) {
            this.jmWorldDir = null;
            if (this.pngFiles != null) {
                this.pngFiles.clear();
                this.pngFiles = null;
            }
            this.enabled = false;
        }

        @Override
        public IGenericTask getTask(atv minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (this.pngFiles.isEmpty()) {
                ChatLog.announceI18N("JourneyMap.file_updates_complete", new Object[0]);
                this.disableTask(minecraft);
                return null;
            }
            return new LegacyMigrationTask(minecraft, this.jmWorldDir, this.pngFiles, this.pngFilesFound);
        }

        @Override
        public void taskAccepted(boolean accepted) {
        }
    }
}

