/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.task.BaseMapTask;
import net.techbrew.journeymap.task.ITaskManager;

public class MapPlayerTask
extends BaseMapTask {
    private static final Logger logger = JourneyMap.getLogger();
    private static ChunkMD.Set lastChunkStubs = new ChunkMD.Set(512);
    private static t lastPlayerPos;
    private static Boolean lastUnderground;
    static Integer chunkOffset;

    private MapPlayerTask(abw world, int dimension, boolean underground, Integer chunkY, ChunkMD.Set chunkStubs) {
        super(world, dimension, underground, chunkY, chunkStubs, false);
    }

    public static BaseMapTask create(uf player) {
        boolean skipUnchanged;
        int missing = 0;
        if (chunkOffset == null) {
            chunkOffset = PropertyManager.getInstance().getInteger(PropertyManager.Key.CHUNK_OFFSET);
        }
        int offset = chunkOffset;
        t playerPos = new t(player.aj, player.ak, player.al);
        Map playerData = DataCache.instance().get(PlayerData.class);
        boolean underground = (Boolean)playerData.get((Object)EntityKey.underground) != false && PropertyManager.getInstance().getBoolean(PropertyManager.Key.PREF_SHOW_CAVES) != false;
        int dimension = (Integer)playerData.get((Object)EntityKey.dimension);
        if (lastUnderground == null) {
            lastUnderground = underground;
        }
        if (lastPlayerPos == null) {
            lastPlayerPos = playerPos;
        }
        boolean bl = skipUnchanged = lastUnderground == underground;
        if (skipUnchanged && underground) {
            boolean bl2 = skipUnchanged = playerPos.b == MapPlayerTask.lastPlayerPos.b;
        }
        if (lastPlayerPos.equals((Object)playerPos) && offset >= 2) {
            offset /= 2;
        }
        lastPlayerPos = playerPos;
        lastUnderground = underground;
        int side = offset + offset + 1;
        int capacity = side * side + side * side / 4;
        ChunkMD.Set chunks = new ChunkMD.Set(capacity);
        abw world = player.q;
        Integer chunkY = underground ? Integer.valueOf(MapPlayerTask.lastPlayerPos.b) : null;
        abp min = new abp(MapPlayerTask.lastPlayerPos.a - offset, MapPlayerTask.lastPlayerPos.c - offset);
        abp max = new abp(MapPlayerTask.lastPlayerPos.a + offset, MapPlayerTask.lastPlayerPos.c + offset);
        for (int x2 = min.a; x2 <= max.a; ++x2) {
            for (int z = min.b; z <= max.b; ++z) {
                abp coord = new abp(x2, z);
                ChunkMD chunkMd = (ChunkMD)lastChunkStubs.get(coord);
                chunkMd = chunkMd == null ? ChunkLoader.getChunkStubFromMemory(x2, z, world) : ChunkLoader.refreshChunkStubFromMemory(chunkMd, world);
                if (chunkMd != null) {
                    chunkMd.render = true;
                    chunks.add(chunkMd);
                    continue;
                }
                ++missing;
            }
        }
        int initialSize = chunks.size();
        if (!lastChunkStubs.isEmpty()) {
            ChunkMD.Set removed = new ChunkMD.Set(64);
            for (ChunkMD oldChunk : lastChunkStubs) {
                if (!chunks.containsKey(oldChunk.coord)) {
                    if (oldChunk.discard(1) <= 4) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Discarding out-of-range chunk: " + oldChunk);
                    }
                    removed.add(oldChunk);
                    continue;
                }
                oldChunk.discard(-1);
                ChunkMD newChunk = (ChunkMD)chunks.get(oldChunk.coord);
                if (skipUnchanged && (newChunk.coord.a != MapPlayerTask.lastPlayerPos.a || newChunk.coord.b != MapPlayerTask.lastPlayerPos.c) && newChunk.stub.equalTo(oldChunk.stub)) {
                    newChunk.render = false;
                }
                if (!newChunk.render.booleanValue() || !logger.isLoggable(Level.FINE)) continue;
                logger.fine("Mapping chunk: " + newChunk);
            }
            lastChunkStubs.keySet().removeAll(removed.keySet());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Chunks in set: " + chunks.size() + ".  lastChunkStubs=" + lastChunkStubs.size());
        }
        return new MapPlayerTask(world, dimension, underground, chunkY, chunks);
    }

    public static void clearCache() {
        lastChunkStubs.clear();
        lastPlayerPos = null;
        lastUnderground = null;
        chunkOffset = null;
    }

    @Override
    public void taskComplete() {
        lastChunkStubs.putAll(this.chunkMdSet);
    }

    public static class Manager
    implements ITaskManager {
        boolean enabled;

        public Class<? extends BaseMapTask> getTaskClass() {
            return MapPlayerTask.class;
        }

        @Override
        public boolean enableTask(atv minecraft, Object params) {
            this.enabled = true;
            return this.enabled;
        }

        @Override
        public boolean isEnabled(atv minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(atv minecraft) {
            this.enabled = false;
        }

        @Override
        public BaseMapTask getTask(atv minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (minecraft.h.ai) {
                BaseMapTask baseMapTask = MapPlayerTask.create((uf)minecraft.h);
                return baseMapTask;
            }
            return null;
        }

        @Override
        public void taskAccepted(boolean accepted) {
        }
    }
}

