/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.awt.Color;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.render.draw.DrawUtil;
import org.lwjgl.opengl.GL11;

public class MapButton
extends aut {
    private Boolean toggled = true;
    String icon;
    bib iconTexture;
    String labelOn;
    String labelOff;
    public boolean h;
    public boolean i;
    public boolean noDisableText;

    private void tempInit() {
        this.h = true;
        this.i = true;
    }

    public MapButton(int id, int x2, int y, String label) {
        super(id, x2, y, label);
        this.tempInit();
    }

    public MapButton(int id, int x2, int y, int width, int height, String label) {
        super(id, x2, y, width, height, label);
        this.tempInit();
    }

    public MapButton(int id, int x2, int y, int width, int height, String labelOn, String labelOff, boolean toggled) {
        super(id, x2, y, width, height, toggled ? labelOn : labelOff);
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.setToggled(toggled);
        this.tempInit();
    }

    public MapButton(int id, int x2, int y, String labelOn, String labelOff, boolean toggled) {
        super(id, x2, y, toggled ? labelOn : labelOff);
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.setToggled(toggled);
        this.tempInit();
    }

    private void updateLabel() {
        if (this.labelOn != null && this.labelOff != null) {
            this.f = this.getToggled() != false ? this.labelOn : this.labelOff;
        }
    }

    public void toggle() {
        this.setToggled(this.getToggled() == false);
    }

    public void setToggled(Boolean toggled) {
        this.toggled = toggled;
        this.updateLabel();
    }

    public void a(atv minecraft, int mouseX, int mouseY) {
        if (!this.i) {
            return;
        }
        super.a(minecraft, mouseX, mouseY);
        if (!this.h) {
            if (this.mouseOver(mouseX, mouseY)) {
                if (this.noDisableText) {
                    DrawUtil.drawRectangle(this.getX(), this.getY(), this.b, this.c, Color.darkGray, 185);
                } else {
                    DrawUtil.drawRectangle(this.getX() + 1, this.getY() + 1, this.b - 2, this.c - 2, Color.darkGray, 255);
                    this.a(minecraft.l, Constants.getString("MapOverlay.disabled_feature"), this.d + this.b / 2, this.e + (this.c - 8) / 2, -6250336);
                }
            } else {
                DrawUtil.drawRectangle(this.getX(), this.getY(), this.b, this.c, Color.darkGray, 185);
            }
        }
        if (this.icon != null) {
            bfq tessellator = bfq.a;
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.h) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            GL11.glDisable((int)3008);
            GL11.glBindTexture((int)3553, (int)this.iconTexture.b());
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            int height = this.getHeight();
            int width = this.getWidth();
            int w2 = this.getToggled() != false ? width : (int)Math.ceil((double)width * 0.6);
            int h = this.getToggled() != false ? height : (int)Math.ceil((double)height * 0.6);
            int widthOffset = (width - w2) / 2;
            int heightOffset = height - h;
            tessellator.b();
            int xPosition = this.getX();
            int yPosition = this.getY();
            tessellator.a((double)(xPosition + widthOffset), (double)(h + yPosition + heightOffset), 0.0, 0.0, 1.0);
            tessellator.a((double)(xPosition + w2 + widthOffset), (double)(h + yPosition + heightOffset), 0.0, 1.0, 1.0);
            tessellator.a((double)(xPosition + w2 + widthOffset), (double)(yPosition + heightOffset), 0.0, 1.0, 0.0);
            tessellator.a((double)(xPosition + widthOffset), (double)(yPosition + heightOffset), 0.0, 0.0, 0.0);
            tessellator.a();
        }
    }

    public boolean c(atv minecraft, int i, int j) {
        return this.h && this.i && i >= this.getX() && j >= this.getY() && i < this.getX() + this.getWidth() && j < this.getY() + this.getHeight();
    }

    public boolean mouseOver(int mouseX, int mouseY) {
        return mouseX >= this.d && mouseY >= this.e && mouseX <= this.d + this.b && mouseY <= this.e + this.c;
    }

    public Boolean getToggled() {
        return this.toggled;
    }

    public int getWidth() {
        return this.b;
    }

    public int getHeight() {
        return this.c;
    }

    public int getX() {
        return this.d;
    }

    public int getY() {
        return this.e;
    }

    public void setX(int x2) {
        this.d = x2;
    }

    public void setY(int y) {
        this.e = y;
    }

    public void setPosition(int x2, int y) {
        this.setX(x2);
        this.setY(y);
    }

    public MapButton leftOf(int x2) {
        this.setX(x2 - this.getWidth());
        return this;
    }

    public MapButton rightOf(int x2) {
        this.setX(x2);
        return this;
    }

    public MapButton centerHorizontalOn(int x2) {
        this.setX(x2 - this.getWidth() / 2);
        return this;
    }

    public MapButton leftOf(MapButton other, int margin) {
        this.setX(other.getX() - this.getWidth() - margin);
        return this;
    }

    public MapButton rightOf(MapButton other, int margin) {
        this.setX(other.getX() + other.getWidth() + margin);
        return this;
    }

    public MapButton below(MapButton other, int margin) {
        this.setY(other.getY() + this.getHeight() + margin);
        return this;
    }
}

