/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.map.MapOverlayActions;
import net.techbrew.journeymap.ui.map.MapOverlayHotkeysHelp;
import net.techbrew.journeymap.ui.map.MapOverlayOptions;
import net.techbrew.journeymap.ui.minimap.MiniMap;
import net.techbrew.journeymap.ui.minimap.MiniMapHotkeysHelp;
import net.techbrew.journeymap.ui.minimap.MiniMapOptions;

public class UIManager {
    private MiniMap miniMap;
    private final Logger logger = JourneyMap.getLogger();
    atv minecraft = atv.w();

    public static UIManager getInstance() {
        return Holder.INSTANCE;
    }

    private UIManager() {
        this.miniMap = new MiniMap();
    }

    public void closeAll() {
        this.closeCurrent();
        this.minecraft.a(null);
        this.minecraft.g();
        this.miniMap.setVisible(true);
        TileCache.instance().cleanUp();
    }

    public void closeCurrent() {
        if (this.minecraft.n != null && this.minecraft.n instanceof JmUI) {
            this.logger.fine("Closing " + ((Object)((Object)this.minecraft.n)).getClass());
            ((JmUI)this.minecraft.n).close();
        }
    }

    public void openInventory() {
        this.logger.fine("Opening inventory");
        this.closeAll();
        this.minecraft.a((awe)new axv((uf)this.minecraft.h));
    }

    public void open(Class<? extends JmUI> uiClass) {
        this.closeCurrent();
        try {
            this.logger.fine("Opening UI " + uiClass.getSimpleName());
            this.minecraft.a((awe)uiClass.newInstance());
            this.miniMap.setVisible(false);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Unexpected exception opening UI: " + e);
            this.logger.severe(LogFormatter.toString(e));
            String string = Constants.getMessageJMERR23(e.getMessage());
        }
    }

    public void toggleMinimap() {
        boolean enabled = !this.isMiniMapEnabled();
        PropertyManager.set(PropertyManager.Key.PREF_SHOW_MINIMAP, enabled);
        this.setMiniMapEnabled(enabled);
    }

    public void setMiniMapEnabled(boolean enable) {
        this.miniMap.setEnabled(enable);
    }

    public boolean isMiniMapEnabled() {
        return this.miniMap.isEnabled();
    }

    public void drawMiniMap() {
        if (this.miniMap.isEnabled() && this.miniMap.isVisible()) {
            boolean doDraw;
            awe currentScreen = this.minecraft.n;
            boolean bl = doDraw = currentScreen == null || currentScreen instanceof auw || currentScreen instanceof MiniMapOptions;
            if (doDraw) {
                this.miniMap.drawMap();
            }
        }
    }

    public MiniMap getMiniMap() {
        return this.miniMap;
    }

    public void openMap() {
        ats.a();
        this.open(MapOverlay.class);
    }

    public void openMapHotkeyHelp() {
        this.open(MapOverlayHotkeysHelp.class);
    }

    public void openMiniMapOptions() {
        this.open(MiniMapOptions.class);
    }

    public void openMiniMapHotkeyHelp() {
        this.open(MiniMapHotkeysHelp.class);
    }

    public void openMapOptions() {
        this.open(MapOverlayOptions.class);
    }

    public void openMapActions() {
        this.open(MapOverlayActions.class);
    }

    public void reset() {
        MapOverlay.reset();
        TileCache.instance().invalidateAll();
        TileCache.instance().cleanUp();
        if (this.miniMap != null) {
            this.miniMap.reset();
        }
        this.miniMap = new MiniMap();
    }

    private static class Holder {
        private static final UIManager INSTANCE = new UIManager();

        private Holder() {
        }
    }
}

