/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.overlay.OverlayRadarRenderer;
import net.techbrew.journeymap.render.overlay.OverlayWaypointRenderer;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MapButton;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapChat;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class MapOverlay
extends JmUI {
    static final MapOverlayState state = new MapOverlayState();
    final OverlayWaypointRenderer waypointRenderer = new OverlayWaypointRenderer();
    final OverlayRadarRenderer radarRenderer = new OverlayRadarRenderer();
    static final GridRenderer gridRenderer = new GridRenderer(5);
    Boolean isScrolling = false;
    int msx;
    int msy;
    int mx;
    int my;
    Logger logger = JourneyMap.getLogger();
    MapChat chat;
    MapButton buttonDayNight;
    MapButton buttonFollow;
    MapButton buttonZoomIn;
    MapButton buttonZoomOut;
    MapButton buttonAlert;
    MapButton buttonOptions;
    MapButton buttonActions;
    MapButton buttonClose;
    MapButton buttonMiniMap;
    Color bgColor = new Color(34, 34, 34);
    Color playerInfoFgColor = new Color(0x8888FF);
    Color playerInfoBgColor = new Color(34, 34, 34);
    StatTimer drawScreenTimer = StatTimer.get("MapOverlay.drawScreen");
    StatTimer drawMapTimer = StatTimer.get("MapOverlay.drawScreen.drawMap");
    StatTimer drawMapTimerWithRefresh = StatTimer.get("MapOverlay.drawScreen.drawMap+refreshState");

    public MapOverlay() {
        super(null);
        this.f = FMLClientHandler.instance().getClient();
        state.refresh(this.f, this.f.h);
        gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        gridRenderer.setZoom(MapOverlay.state.currentZoom);
    }

    @Override
    public void A_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.initButtons();
        if (state.getDimension() != this.f.h.ar) {
            gridRenderer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(int width, int height, float f) {
        try {
            this.drawScreenTimer.start();
            this.c(0);
            this.drawMap();
            this.layoutButtons();
            for (int k = 0; k < this.i.size(); ++k) {
                aut guibutton = (aut)this.i.get(k);
                guibutton.a(this.f, width, height);
            }
            if (this.chat != null) {
                this.chat.a(width, height, f);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Unexpected exception in MapOverlay.drawScreen(): " + e);
            this.logger.severe(LogFormatter.toString(e));
            this.close();
        }
        finally {
            this.drawScreenTimer.stop();
        }
    }

    @Override
    protected void a(aut guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.g];
        switch (id) {
            case DayNight: {
                this.toggleDayNight();
                break;
            }
            case Follow: {
                this.toggleFollow();
                break;
            }
            case ZoomIn: {
                this.zoomIn();
                break;
            }
            case ZoomOut: {
                this.zoomOut();
                break;
            }
            case Close: {
                UIManager.getInstance().closeAll();
                break;
            }
            case Alert: {
                VersionCheck.launchWebsite();
                break;
            }
            case Options: {
                UIManager.getInstance().openMapOptions();
                break;
            }
            case Actions: {
                UIManager.getInstance().openMapActions();
            }
        }
    }

    @Override
    public void a(atv minecraft, int width, int height) {
        super.a(minecraft, width, height);
        state.requireRefresh();
        this.layoutButtons();
        if (this.chat == null) {
            this.chat = new MapChat("", true);
        }
        if (this.chat != null) {
            this.chat.a(minecraft, width, height);
        }
        this.A_();
        this.drawMap();
    }

    void initButtons() {
        if (this.i.isEmpty()) {
            String on = Constants.getString("MapOverlay.on");
            String off = Constants.getString("MapOverlay.off");
            this.buttonAlert = new MapButton(ButtonEnum.Alert.ordinal(), 0, 0, Constants.getString("MapOverlay.update_available"));
            this.buttonAlert.i = VersionCheck.getVersionIsChecked() != false && VersionCheck.getVersionIsCurrent() == false;
            this.buttonDayNight = new MapButton(ButtonEnum.DayNight.ordinal(), 0, 0, 80, 20, Constants.getString("MapOverlay.day"), Constants.getString("MapOverlay.night"), state.getMapType() == Constants.MapType.day);
            this.buttonFollow = new MapButton(ButtonEnum.Follow.ordinal(), 0, 0, 80, 20, Constants.getString("MapOverlay.follow", on), Constants.getString("MapOverlay.follow", off), MapOverlay.state.follow);
            this.buttonZoomIn = new MapButton(ButtonEnum.ZoomIn.ordinal(), 0, 0, 20, 20, "+");
            this.buttonZoomIn.noDisableText = true;
            this.buttonZoomOut = new MapButton(ButtonEnum.ZoomOut.ordinal(), 0, 0, 20, 20, "-");
            this.buttonZoomOut.noDisableText = true;
            this.buttonZoomOut.h = MapOverlay.state.currentZoom > MapOverlay.state.minZoom;
            this.buttonZoomIn.h = MapOverlay.state.currentZoom < MapOverlay.state.maxZoom;
            this.buttonClose = new MapButton(ButtonEnum.Close.ordinal(), 0, 0, 60, 20, Constants.getString("MapOverlay.close"));
            this.buttonOptions = new MapButton(ButtonEnum.Options.ordinal(), 0, 0, 60, 20, Constants.getString("MapOverlay.options"));
            this.buttonActions = new MapButton(ButtonEnum.Actions.ordinal(), 0, 0, 60, 20, Constants.getString("MapOverlay.actions"));
            if (this.buttonAlert.i) {
                this.i.add(this.buttonAlert);
            }
            this.i.add(this.buttonDayNight);
            this.i.add(this.buttonFollow);
            this.i.add(this.buttonZoomIn);
            this.i.add(this.buttonZoomOut);
            this.i.add(this.buttonClose);
            this.i.add(this.buttonOptions);
            this.i.add(this.buttonActions);
        }
    }

    @Override
    protected void layoutButtons() {
        boolean underground;
        if (this.i.isEmpty()) {
            this.initButtons();
        }
        boolean smallScale = this.f.u.al == 1;
        int startX = smallScale ? 60 : 40;
        int endX = this.g - 3;
        int startY = 3;
        int hgap = 3;
        int vgap = 3;
        this.buttonDayNight.setPosition(startX, 3);
        this.buttonZoomIn.setPosition(smallScale ? 20 : 8, smallScale ? 64 : 32);
        this.buttonZoomOut.below(this.buttonZoomIn, 8).setX(this.buttonZoomIn.getX());
        if (this.g >= 420) {
            this.buttonFollow.rightOf(this.buttonDayNight, 3).setY(3);
            this.buttonClose.leftOf(endX).setY(3);
            this.buttonActions.leftOf(this.buttonClose, 3).setY(3);
            this.buttonOptions.leftOf(this.buttonActions, 3).setY(3);
            if (this.buttonAlert.i) {
                this.buttonAlert.below(this.buttonClose, 3).leftOf(endX);
            }
        } else {
            this.buttonFollow.below(this.buttonDayNight, 3).setX(startX);
            if (this.buttonAlert.i) {
                this.buttonAlert.leftOf(endX).setY(3);
                this.buttonClose.leftOf(endX).below(this.buttonAlert, 3);
            } else {
                this.buttonClose.leftOf(endX).setY(3);
            }
            this.buttonActions.below(this.buttonClose, 3).leftOf(endX);
            this.buttonOptions.below(this.buttonActions, 3).leftOf(endX);
        }
        this.buttonDayNight.h = !(underground = ((Boolean)DataCache.instance().get(PlayerData.class).get((Object)EntityKey.underground)).booleanValue()) || PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_CAVES) == false;
    }

    @Override
    public void d() {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.d();
        }
        this.mx = Mouse.getEventX() * this.g / this.f.d;
        this.my = this.h - Mouse.getEventY() * this.h / this.f.e - 1;
        if (Mouse.getEventButtonState()) {
            this.a(this.mx, this.my, Mouse.getEventButton());
        } else {
            int wheel = Mouse.getEventDWheel();
            if (wheel > 0) {
                this.zoomIn();
            } else if (wheel < 0) {
                this.zoomOut();
            } else {
                this.b(this.mx, this.my, Mouse.getEventButton());
            }
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.a(mouseX, mouseY, mouseButton);
        }
        super.a(mouseX, mouseY, mouseButton);
        Boolean guiButtonUsed = false;
        if (mouseButton == 0) {
            for (int l = 0; l < this.i.size(); ++l) {
                aut guibutton = (aut)this.i.get(l);
                if (!guibutton.c(this.f, mouseX, mouseY)) continue;
                guiButtonUsed = true;
                break;
            }
        }
    }

    @Override
    protected void b(int mouseX, int mouseY, int which) {
        super.b(mouseX, mouseY, which);
        if (Mouse.isButtonDown((int)0) && this.mouseOverButtons(mouseX, mouseY)) {
            return;
        }
        if (Mouse.isButtonDown((int)0) && !this.isScrolling.booleanValue()) {
            this.isScrolling = true;
            this.msx = this.mx;
            this.msy = this.my;
        } else if (!Mouse.isButtonDown((int)0) && this.isScrolling.booleanValue()) {
            this.isScrolling = false;
            int blockSize = (int)Math.pow(2.0, MapOverlay.state.currentZoom);
            int mouseDragX = (this.mx - this.msx) * 2 / blockSize;
            int mouseDragY = (this.my - this.msy) * 2 / blockSize;
            this.msx = this.mx;
            this.msy = this.my;
            if (gridRenderer != null) {
                try {
                    gridRenderer.move(-mouseDragX, -mouseDragY);
                    gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.f.d, this.f.e, false, 0.0, 0.0);
                    gridRenderer.setZoom(MapOverlay.state.currentZoom);
                }
                catch (Exception e) {
                    this.logger.severe("Error moving grid: " + e);
                }
            }
            this.setFollow(false);
            this.refreshState();
        }
    }

    void zoomIn() {
        if (MapOverlay.state.currentZoom < MapOverlay.state.maxZoom) {
            this.setZoom(MapOverlay.state.currentZoom + 1);
        }
    }

    void zoomOut() {
        if (MapOverlay.state.currentZoom > MapOverlay.state.minZoom) {
            this.setZoom(MapOverlay.state.currentZoom - 1);
        }
    }

    private void setZoom(int zoom) {
        if (state.setZoom(zoom)) {
            this.buttonZoomOut.h = MapOverlay.state.currentZoom > MapOverlay.state.minZoom;
            this.buttonZoomIn.h = MapOverlay.state.currentZoom < MapOverlay.state.maxZoom;
            this.refreshState();
        }
    }

    void toggleDayNight() {
        this.buttonDayNight.toggle();
        if (this.buttonDayNight.getToggled().booleanValue()) {
            state.overrideMapType(Constants.MapType.day);
        } else {
            state.overrideMapType(Constants.MapType.night);
        }
        this.refreshState();
    }

    void toggleFollow() {
        this.setFollow(!MapOverlay.state.follow);
    }

    void setFollow(Boolean onPlayer) {
        if (MapOverlay.state.follow == onPlayer) {
            return;
        }
        this.buttonFollow.setToggled(onPlayer);
        MapOverlay.state.follow = onPlayer;
        if (MapOverlay.state.follow) {
            this.refreshState();
        }
    }

    @Override
    public void a(char c, int i) {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.a(c, i);
            return;
        }
        if (i == 1) {
            UIManager.getInstance().closeAll();
            return;
        }
        if (i == Constants.KB_MAP_ZOOMIN.d) {
            this.zoomIn();
            return;
        }
        if (i == Constants.KB_MAP_ZOOMOUT.d) {
            this.zoomOut();
            return;
        }
        if (i == Constants.KB_MAP_DAY.d) {
            state.overrideMapType(Constants.MapType.day);
            return;
        }
        if (i == Constants.KB_MAP_NIGHT.d) {
            state.overrideMapType(Constants.MapType.night);
            return;
        }
        if (i == this.f.u.I.d) {
            this.moveCanvas(0, -16);
            return;
        }
        if (i == this.f.u.J.d) {
            this.moveCanvas(-16, 0);
            return;
        }
        if (i == this.f.u.K.d) {
            this.moveCanvas(0, 16);
            return;
        }
        if (i == this.f.u.L.d) {
            this.moveCanvas(16, 0);
            return;
        }
        if (i == this.f.u.N.d) {
            this.close();
            this.f.a((awe)new axv((uf)this.f.h));
            return;
        }
        if (i == this.f.u.P.d) {
            this.openChat("");
            return;
        }
        if (i == this.f.u.V.d) {
            this.openChat("/");
            return;
        }
    }

    @Override
    public void c() {
        super.c();
        if (this.chat != null) {
            this.chat.c();
        }
        this.layoutButtons();
    }

    @Override
    public void c(int layer) {
        DrawUtil.drawRectangle(0.0, 0.0, this.g, this.h, this.bgColor, 255);
    }

    void drawMap() {
        boolean refreshReady = this.isRefreshReady();
        StatTimer timer = refreshReady ? this.drawMapTimerWithRefresh : this.drawMapTimer;
        timer.start();
        this.sizeDisplay(false);
        int xOffset = 0;
        int yOffset = 0;
        if (this.isScrolling.booleanValue()) {
            int blockSize = (int)Math.pow(2.0, MapOverlay.state.currentZoom);
            int mouseDragX = (this.mx - this.msx) * 2 / blockSize;
            int mouseDragY = (this.my - this.msy) * 2 / blockSize;
            xOffset = mouseDragX * blockSize;
            yOffset = mouseDragY * blockSize;
        } else if (refreshReady) {
            this.refreshState();
        } else {
            gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        }
        if (MapOverlay.state.follow) {
            gridRenderer.center(this.f.h.u, this.f.h.w, MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.f.d, this.f.e, false, 0.0, 0.0);
        gridRenderer.draw(1.0f, xOffset, yOffset);
        gridRenderer.draw(state.getDrawSteps(), xOffset, yOffset, 1.0f);
        Point2D.Double playerPixel = gridRenderer.getPixel(this.f.h.u, this.f.h.w);
        if (playerPixel != null) {
            TextureImpl tex = MapOverlay.state.currentZoom == 0 ? TextureCache.instance().getPlayerLocatorSmall() : TextureCache.instance().getPlayerLocator();
            DrawEntityStep drawStep = new DrawEntityStep(this.f.h.u, this.f.h.w, EntityHelper.getHeading((nn)this.f.h), false, tex, 8);
            gridRenderer.draw(xOffset, yOffset, 1.0f, drawStep);
        }
        DrawUtil.drawImage(TextureCache.instance().getLogo(), 16.0, 4.0, false, 1.0f);
        this.sizeDisplay(true);
        DrawUtil.drawCenteredLabel(MapOverlay.state.playerLastPos, this.g / 2, this.h - 11, this.playerInfoBgColor, this.playerInfoFgColor, 205, 1.0);
        timer.stop();
    }

    public static void drawMapBackground(JmUI ui) {
        ui.sizeDisplay(false);
        atv mc = ui.f;
        if (state.shouldRefresh(ui.f)) {
            bdi player = ui.f.h;
            if (player == null) {
                return;
            }
            MapOverlayState state = MapOverlay.state();
            state.refresh(ui.f, player);
            gridRenderer.setContext(state.getWorldDir(), state.getDimension());
            if (state.follow) {
                gridRenderer.center(ui.f.h.u, ui.f.h.w, state.currentZoom);
            } else {
                gridRenderer.setZoom(state.currentZoom);
            }
            gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), mc.d, mc.e, true, 0.0, 0.0);
        } else {
            gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        }
        if (MapOverlay.state.follow) {
            gridRenderer.center(mc.h.u, mc.h.w, MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), mc.d, mc.e, false, 0.0, 0.0);
        gridRenderer.draw(1.0f, 0.0, 0.0);
        gridRenderer.draw(state.getDrawSteps(), 0, 0, 1.0f);
        Point2D.Double playerPixel = gridRenderer.getPixel(mc.h.u, mc.h.w);
        if (playerPixel != null) {
            TextureImpl tex = MapOverlay.state.currentZoom == 0 ? TextureCache.instance().getPlayerLocatorSmall() : TextureCache.instance().getPlayerLocator();
            DrawEntityStep drawStep = new DrawEntityStep(mc.h.u, mc.h.w, EntityHelper.getHeading((nn)mc.h), false, tex, 8);
            gridRenderer.draw(0, 0, 1.0f, drawStep);
        }
        DrawUtil.drawImage(TextureCache.instance().getLogo(), 16.0, 4.0, false, 1.0f);
        ui.sizeDisplay(true);
    }

    void refreshState() {
        bdi player = this.f.h;
        if (player == null) {
            this.logger.warning("Could not get player");
            return;
        }
        state.refresh(this.f, player);
        if (state.getDimension() != gridRenderer.getDimension()) {
            this.setFollow(true);
        }
        gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        if (MapOverlay.state.follow) {
            gridRenderer.center(this.f.h.u, this.f.h.w, MapOverlay.state.currentZoom);
        } else {
            gridRenderer.setZoom(MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.f.d, this.f.e, true, 0.0, 0.0);
        state.generateDrawSteps(this.f, gridRenderer, this.waypointRenderer, this.radarRenderer, 1.0f);
        MapOverlay.state.playerLastPos = Constants.getString("MapOverlay.player_location", Integer.toString((int)this.f.h.u), Integer.toString((int)this.f.h.w), Integer.toString((int)this.f.h.v), this.f.h.ak, state.getPlayerBiome());
        state.updateLastRefresh();
        TileCache.instance().cleanUp();
    }

    void openChat(String defaultText) {
        if (this.chat != null) {
            this.chat.setText(defaultText);
            this.chat.setHidden(false);
        } else {
            this.chat = new MapChat(defaultText, false);
            this.chat.a(this.f, this.g, this.h);
        }
    }

    @Override
    public void close() {
        if (this.chat != null) {
            this.chat.close();
        }
    }

    @Override
    public void b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    boolean isRefreshReady() {
        if (this.isScrolling.booleanValue()) {
            return false;
        }
        return state.shouldRefresh(this.f);
    }

    void moveCanvas(int deltaBlockX, int deltaBlockz) {
        this.refreshState();
        gridRenderer.move(deltaBlockX, deltaBlockz);
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.f.d, this.f.e, true, 0.0, 0.0);
        this.setFollow(false);
    }

    @Override
    public final boolean f() {
        return false;
    }

    public static synchronized MapOverlayState state() {
        return state;
    }

    public static void reset() {
        state.requireRefresh();
        gridRenderer.clear();
        TileCache.instance().invalidateAll();
        TileCache.instance().cleanUp();
    }

    private static enum ButtonEnum {
        Alert,
        DayNight,
        Follow,
        ZoomIn,
        ZoomOut,
        Options,
        Actions,
        Close,
        MiniMap;

    }
}

