/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.io.MapSaver;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.task.MapRegionTask;
import net.techbrew.journeymap.task.SaveMapTask;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MapButton;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.AutoMapConfirmation;
import net.techbrew.journeymap.ui.map.MapOverlay;

public class MapOverlayActions
extends JmUI {
    MapButton buttonAutomap;
    MapButton buttonSave;
    MapButton buttonClose;
    MapButton buttonBrowser;
    MapButton buttonCheck;

    public MapOverlayActions() {
        super(Constants.getString("MapOverlay.actions"));
    }

    @Override
    public void A_() {
        this.i.clear();
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        this.buttonSave = new MapButton(ButtonEnum.Save.ordinal(), 0, 0, Constants.getString("MapOverlay.save_map"));
        this.buttonClose = new MapButton(ButtonEnum.Close.ordinal(), 0, 0, Constants.getString("MapOverlay.close"));
        this.buttonBrowser = new MapButton(ButtonEnum.Browser.ordinal(), 0, 0, Constants.getString("MapOverlay.use_browser"));
        this.buttonBrowser.h = PropertyManager.getBooleanProp(PropertyManager.Key.WEBSERVER_ENABLED);
        this.buttonAutomap = new MapButton(ButtonEnum.Automap.ordinal(), 0, 0, Constants.getString("MapOverlay.automap_title", on), Constants.getString("MapOverlay.automap_title", off), true);
        this.buttonAutomap.h = atv.w().B();
        this.buttonCheck = new MapButton(ButtonEnum.Check.ordinal(), 0, 0, Constants.getString("MapOverlay.update_check"));
        this.i.add(this.buttonAutomap);
        this.i.add(this.buttonSave);
        this.i.add(this.buttonCheck);
        this.i.add(this.buttonBrowser);
        this.i.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons() {
        if (this.i.isEmpty()) {
            this.A_();
        }
        this.buttonSave.h = !JourneyMap.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
        int hgap = 4;
        int vgap = 3;
        int bx = (this.g - 4) / 2;
        int by2 = this.h / 4;
        this.buttonAutomap.leftOf(bx).setY(by2);
        this.buttonBrowser.rightOf(this.buttonAutomap, 4).setY(by2);
        this.buttonSave.below(this.buttonAutomap, 3).leftOf(bx);
        this.buttonCheck.below(this.buttonBrowser, 3).rightOf(this.buttonSave, 4);
        this.buttonClose.below(this.buttonSave, 12).centerHorizontalOn(bx);
    }

    @Override
    protected void a(aut guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.g];
        switch (id) {
            case Save: {
                this.save();
                UIManager.getInstance().openMap();
                break;
            }
            case Close: {
                UIManager.getInstance().openMap();
                break;
            }
            case Browser: {
                this.launchLocalhost();
                UIManager.getInstance().openMap();
                break;
            }
            case Automap: {
                UIManager.getInstance().open(AutoMapConfirmation.class);
                break;
            }
            case Check: {
                VersionCheck.launchWebsite();
                UIManager.getInstance().openMap();
            }
        }
    }

    protected void launchLocalhost() {
        String port = PropertyManager.getInstance().getString(PropertyManager.Key.WEBSERVER_PORT);
        String url = "http://localhost:" + port;
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Could not launch browser with URL: " + url, e);
            this.logger.severe(LogFormatter.toString(e));
        }
    }

    void save() {
        MapOverlayState state = MapOverlay.state();
        Constants.MapType mapType = state.getMapType();
        Integer vSlice = state.getMapType() == Constants.MapType.underground ? state.getVSlice() : null;
        MapSaver mapSaver = new MapSaver(state.getWorldDir(), mapType, vSlice, state.getDimension());
        if (mapSaver.isValid()) {
            JourneyMap.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
            ChatLog.announceI18N("MapOverlay.save_filename", mapSaver.getSaveFileName());
        }
        this.close();
    }

    @Override
    protected void a(char c, int i) {
        switch (i) {
            case 1: {
                UIManager.getInstance().openMap();
            }
        }
    }

    private static enum ButtonEnum {
        Automap,
        Check,
        Save,
        Browser,
        Close;

    }
}

