/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.model.WaypointHelper;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MapButton;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;

public class MapOverlayOptions
extends JmUI {
    int lastWidth = 0;
    int lastHeight = 0;
    MapButton buttonCaves;
    MapButton buttonMonsters;
    MapButton buttonAnimals;
    MapButton buttonVillagers;
    MapButton buttonPets;
    MapButton buttonPlayers;
    MapButton buttonWaypoints;
    MapButton buttonGrid;
    MapButton buttonWebserver;
    MapButton buttonMiniMap;
    MapButton buttonKeyboardHelp;
    MapButton buttonClose;

    public MapOverlayOptions() {
        super(Constants.getString("MapOverlay.options"));
    }

    @Override
    public void A_() {
        this.i.clear();
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        this.buttonCaves = new MapButton(ButtonEnum.Caves.ordinal(), 0, 0, Constants.getString("MapOverlay.show_caves", on), Constants.getString("MapOverlay.show_caves", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_CAVES));
        this.buttonClose = new MapButton(ButtonEnum.Close.ordinal(), 0, 0, Constants.getString("MapOverlay.close"));
        this.buttonMonsters = new MapButton(ButtonEnum.Monsters.ordinal(), 0, 0, Constants.getString("MapOverlay.show_monsters", on), Constants.getString("MapOverlay.show_monsters", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_MOBS));
        this.buttonAnimals = new MapButton(ButtonEnum.Animals.ordinal(), 0, 0, Constants.getString("MapOverlay.show_animals", on), Constants.getString("MapOverlay.show_animals", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_ANIMALS));
        this.buttonVillagers = new MapButton(ButtonEnum.Villagers.ordinal(), 0, 0, Constants.getString("MapOverlay.show_villagers", on), Constants.getString("MapOverlay.show_villagers", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_VILLAGERS));
        this.buttonPets = new MapButton(ButtonEnum.Pets.ordinal(), 0, 0, Constants.getString("MapOverlay.show_pets", on), Constants.getString("MapOverlay.show_pets", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_PETS));
        this.buttonPlayers = new MapButton(ButtonEnum.Players.ordinal(), 0, 0, Constants.getString("MapOverlay.show_players", on), Constants.getString("MapOverlay.show_players", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_PLAYERS));
        this.buttonWaypoints = new MapButton(ButtonEnum.Waypoints.ordinal(), 0, 0, Constants.getString("MapOverlay.show_waypoints", on), Constants.getString("MapOverlay.show_waypoints", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_WAYPOINTS));
        this.buttonWaypoints.h = WaypointHelper.waypointsEnabled();
        boolean webserverOn = PropertyManager.getInstance().getBoolean(PropertyManager.Key.WEBSERVER_ENABLED);
        this.buttonWebserver = new MapButton(ButtonEnum.Webserver.ordinal(), 0, 0, Constants.getString("MapOverlay.enable_webserver", on), Constants.getString("MapOverlay.enable_webserver", off), webserverOn);
        this.buttonWebserver.setToggled(webserverOn);
        this.buttonMiniMap = new MapButton(ButtonEnum.MiniMap.ordinal(), 0, 0, Constants.getString("MapOverlay.minimap"));
        this.buttonKeyboardHelp = new MapButton(ButtonEnum.KeyboardHelp.ordinal(), 0, 0, Constants.getString("MapOverlay.hotkeys_button"));
        boolean gridOn = PropertyManager.getInstance().getBoolean(PropertyManager.Key.PREF_SHOW_GRID);
        this.buttonGrid = new MapButton(ButtonEnum.Grid.ordinal(), 0, 0, Constants.getString("MapOverlay.show_grid", on), Constants.getString("MapOverlay.show_grid", off), gridOn);
        if (!FeatureManager.isAllowed(Feature.MapCaves)) {
            this.buttonCaves.setToggled(false);
            this.buttonCaves.h = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarMobs)) {
            this.buttonMonsters.setToggled(false);
            this.buttonMonsters.h = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarAnimals)) {
            this.buttonAnimals.setToggled(false);
            this.buttonAnimals.h = false;
            this.buttonPets.setToggled(false);
            this.buttonPets.h = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarVillagers)) {
            this.buttonVillagers.setToggled(false);
            this.buttonVillagers.h = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarPlayers)) {
            this.buttonPlayers.setToggled(false);
            this.buttonPlayers.h = false;
        }
        this.i.add(this.buttonCaves);
        this.i.add(this.buttonClose);
        this.i.add(this.buttonMonsters);
        this.i.add(this.buttonAnimals);
        this.i.add(this.buttonVillagers);
        this.i.add(this.buttonPets);
        this.i.add(this.buttonPlayers);
        this.i.add(this.buttonGrid);
        this.i.add(this.buttonWaypoints);
        this.i.add(this.buttonWebserver);
        this.i.add(this.buttonKeyboardHelp);
        this.i.add(this.buttonMiniMap);
    }

    @Override
    protected void layoutButtons() {
        if (this.i.isEmpty()) {
            this.A_();
        }
        if (this.lastWidth != this.g || this.lastHeight != this.h) {
            this.lastWidth = this.g;
            this.lastHeight = this.h;
            int hgap = 4;
            int vgap = 3;
            int bx = (this.g - 4) / 2;
            int by2 = this.h / 4;
            this.buttonCaves.leftOf(bx).setY(by2);
            this.buttonMonsters.rightOf(this.buttonCaves, 4).setY(by2);
            this.buttonAnimals.below(this.buttonCaves, 3).leftOf(bx);
            this.buttonVillagers.rightOf(this.buttonAnimals, 4).below(this.buttonMonsters, 3);
            this.buttonPets.below(this.buttonAnimals, 3).leftOf(bx);
            this.buttonPlayers.rightOf(this.buttonPets, 4).below(this.buttonVillagers, 3);
            this.buttonGrid.below(this.buttonPets, 3).leftOf(bx);
            this.buttonWaypoints.rightOf(this.buttonGrid, 4).below(this.buttonPlayers, 3);
            this.buttonMiniMap.below(this.buttonGrid, 3).leftOf(bx);
            this.buttonWebserver.rightOf(this.buttonMiniMap, 3).below(this.buttonWaypoints, 3);
            this.buttonKeyboardHelp.below(this.buttonWebserver, 3).centerHorizontalOn(bx);
            this.buttonClose.below(this.buttonKeyboardHelp, 3).centerHorizontalOn(bx);
        }
    }

    @Override
    protected void a(aut guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.g];
        switch (id) {
            case Caves: {
                this.buttonCaves.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_CAVES));
                boolean underground = (Boolean)DataCache.instance().get(PlayerData.class).get((Object)EntityKey.underground);
                if (!underground) break;
                MapOverlay.state().requireRefresh();
                break;
            }
            case Close: {
                UIManager.getInstance().openMap();
                break;
            }
            case Monsters: {
                this.buttonMonsters.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_MOBS));
                break;
            }
            case Animals: {
                this.buttonAnimals.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_ANIMALS));
                break;
            }
            case Villagers: {
                this.buttonVillagers.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_VILLAGERS));
                break;
            }
            case Pets: {
                this.buttonPets.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_PETS));
                break;
            }
            case Players: {
                this.buttonPlayers.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_PLAYERS));
                break;
            }
            case Waypoints: {
                this.buttonWaypoints.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_WAYPOINTS));
                break;
            }
            case Grid: {
                this.buttonGrid.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_GRID));
                MapOverlay.state().requireRefresh();
                break;
            }
            case Webserver: {
                this.buttonWebserver.setToggled(PropertyManager.toggle(PropertyManager.Key.WEBSERVER_ENABLED));
                JourneyMap.getInstance().toggleWebserver(this.buttonWebserver.getToggled(), true);
                break;
            }
            case MiniMap: {
                UIManager.getInstance().openMiniMapOptions();
                break;
            }
            case KeyboardHelp: {
                UIManager.getInstance().openMapHotkeyHelp();
            }
        }
    }

    @Override
    protected void a(char c, int i) {
        switch (i) {
            case 1: {
                UIManager.getInstance().openMap();
            }
        }
    }

    private static enum ButtonEnum {
        Caves,
        Monsters,
        Animals,
        Villagers,
        Pets,
        Players,
        Waypoints,
        Grid,
        Webserver,
        MiniMap,
        KeyboardHelp,
        Close;

    }
}

