/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.minimap;

import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DisplayVars {
    final Position position;
    final Shape shape;
    final TextureImpl borderTexture;
    final TextureImpl maskTexture;
    final float drawScale;
    final double fontScale;
    final int displayWidth;
    final int displayHeight;
    final awf scaledResolution;
    final int minimapSize;
    final int textureX;
    final int textureY;
    final double minimapOffset;
    final double translateX;
    final double translateY;
    final int marginX;
    final int marginY;
    final int scissorX;
    final int scissorY;
    final int labelX;
    final int topLabelY;
    final int bottomLabelY;

    DisplayVars(atv mc, Shape shape, Position position, double fontScale) {
        this.shape = shape;
        this.position = position;
        this.fontScale = fontScale;
        this.displayWidth = mc.d;
        this.displayHeight = mc.e;
        this.scaledResolution = new awf(mc.u, mc.d, mc.e);
        int topLabelYOffset = 0;
        int bottomLabelYOffset = 0;
        int bottomTextureYMargin = 0;
        switch (shape) {
            case LargeCircle: {
                this.drawScale = 1.0f;
                this.borderTexture = TextureCache.instance().getMinimapLargeCircle();
                this.maskTexture = TextureCache.instance().getMinimapLargeCircleMask();
                this.minimapSize = 512;
                this.marginX = 3;
                this.marginY = 3;
                if (fontScale == 1.0) {
                    topLabelYOffset = 6;
                    bottomLabelYOffset = 4;
                    bottomTextureYMargin = 10;
                    break;
                }
                topLabelYOffset = 9;
                bottomLabelYOffset = 6;
                bottomTextureYMargin = 20;
                break;
            }
            case SmallCircle: {
                this.drawScale = 0.5f;
                this.borderTexture = TextureCache.instance().getMinimapSmallCircle();
                this.maskTexture = TextureCache.instance().getMinimapSmallCircleMask();
                this.minimapSize = 256;
                this.marginX = 2;
                this.marginY = 2;
                if (fontScale == 1.0) {
                    topLabelYOffset = 6;
                    bottomLabelYOffset = 6;
                    bottomTextureYMargin = 14;
                    break;
                }
                topLabelYOffset = 9;
                bottomLabelYOffset = 10;
                bottomTextureYMargin = 24;
                break;
            }
            case LargeSquare: {
                this.drawScale = 1.0f;
                this.borderTexture = TextureCache.instance().getMinimapLargeSquare();
                this.maskTexture = null;
                this.minimapSize = 512;
                this.marginX = 0;
                this.marginY = 0;
                if (fontScale == 1.0) {
                    topLabelYOffset = 7;
                    bottomLabelYOffset = -6 - mc.l.a;
                    break;
                }
                topLabelYOffset = 9;
                bottomLabelYOffset = -14 - mc.l.a;
                break;
            }
            default: {
                this.drawScale = 0.5f;
                this.borderTexture = TextureCache.instance().getMinimapSmallSquare();
                this.maskTexture = null;
                this.minimapSize = 256;
                this.marginX = 0;
                this.marginY = 0;
                if (fontScale == 1.0) {
                    topLabelYOffset = 7;
                    bottomLabelYOffset = -6 - mc.l.a;
                    break;
                }
                topLabelYOffset = 9;
                bottomLabelYOffset = -14 - mc.l.a;
            }
        }
        this.minimapOffset = (double)this.minimapSize * 0.5;
        boolean textureOffsetX = false;
        switch (position) {
            case BottomRight: {
                this.textureX = mc.d - this.borderTexture.width + 0 - this.marginX;
                this.textureY = mc.e - this.borderTexture.height - this.marginY - bottomTextureYMargin;
                this.translateX = (double)(mc.d / 2) - this.minimapOffset;
                this.translateY = (double)(mc.e / 2) - this.minimapOffset - (double)bottomTextureYMargin;
                this.scissorX = mc.d - this.minimapSize - this.marginX;
                this.scissorY = this.marginY + bottomTextureYMargin;
                this.labelX = mc.d - this.minimapSize / 2;
                this.topLabelY = mc.e - this.minimapSize + topLabelYOffset - bottomTextureYMargin;
                this.bottomLabelY = mc.e - this.marginY - this.marginY + bottomLabelYOffset - bottomTextureYMargin;
                break;
            }
            case TopLeft: {
                this.textureX = 0 + this.marginX;
                this.textureY = this.marginY;
                this.translateX = (double)(-(mc.d / 2)) + this.minimapOffset;
                this.translateY = (double)(-(mc.e / 2)) + this.minimapOffset;
                this.scissorX = 0 + this.marginX;
                this.scissorY = mc.e - this.minimapSize - this.marginY;
                this.labelX = this.minimapSize / 2;
                this.topLabelY = this.marginY + topLabelYOffset;
                this.bottomLabelY = this.minimapSize + bottomLabelYOffset;
                break;
            }
            case BottomLeft: {
                this.textureX = 0 + this.marginX;
                this.textureY = mc.e - this.borderTexture.height - this.marginY - bottomTextureYMargin;
                this.translateX = (double)(-(mc.d / 2)) + this.minimapOffset;
                this.translateY = (double)(mc.e / 2) - this.minimapOffset - (double)bottomTextureYMargin;
                this.scissorX = this.marginX;
                this.scissorY = this.marginY + bottomTextureYMargin;
                this.labelX = this.minimapSize / 2;
                this.topLabelY = mc.e - this.minimapSize + topLabelYOffset - bottomTextureYMargin;
                this.bottomLabelY = mc.e - this.marginY - this.marginY + bottomLabelYOffset - bottomTextureYMargin;
                break;
            }
            default: {
                this.textureX = mc.d - this.borderTexture.width + 0 - this.marginX;
                this.textureY = this.marginY;
                this.translateX = (double)(mc.d / 2) - this.minimapOffset;
                this.translateY = (double)(-(mc.e / 2)) + this.minimapOffset;
                this.scissorX = mc.d - this.minimapSize - this.marginX;
                this.scissorY = mc.e - this.minimapSize - this.marginY;
                this.labelX = mc.d - this.minimapSize / 2;
                this.topLabelY = this.marginY + topLabelYOffset;
                this.bottomLabelY = this.minimapSize + bottomLabelYOffset;
            }
        }
    }

    public static enum Shape {
        SmallSquare("MiniMap.shape_smallsquare"),
        LargeSquare("MiniMap.shape_largesquare"),
        SmallCircle("MiniMap.shape_smallcircle"),
        LargeCircle("MiniMap.shape_largecircle");

        public final String label;
        public static Shape[] Enabled;

        private Shape(String label) {
            this.label = label;
        }

        static {
            Enabled = new Shape[]{SmallSquare, LargeSquare};
        }
    }

    public static enum Position {
        TopRight("MiniMap.position_topright"),
        BottomRight("MiniMap.position_bottomright"),
        BottomLeft("MiniMap.position_bottomleft"),
        TopLeft("MiniMap.position_topleft");

        public final String label;

        private Position(String label) {
            this.label = label;
        }
    }
}

