/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.minimap;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.model.WaypointHelper;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.overlay.OverlayRadarRenderer;
import net.techbrew.journeymap.render.overlay.OverlayWaypointRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.minimap.DisplayVars;
import org.lwjgl.opengl.GL11;

public class MiniMap {
    private final Logger logger = JourneyMap.getLogger();
    private final atv mc = atv.w();
    private final MapOverlayState state = MapOverlay.state();
    private final OverlayWaypointRenderer waypointRenderer = new OverlayWaypointRenderer();
    private final OverlayRadarRenderer radarRenderer = new OverlayRadarRenderer();
    private final GridRenderer gridRenderer = new GridRenderer(3);
    private StatTimer drawTimer;
    private final Color playerInfoFgColor = Color.LIGHT_GRAY;
    private final Color playerInfoBgColor = new Color(34, 34, 34);
    private Boolean enabled;
    private Boolean showFps = true;
    private DisplayVars dv;
    private boolean visible = true;
    private bdi player;
    private Point2D playerPixel;
    private TextureImpl playerLocatorTex;
    float lightmapS = 240.0f;
    float lightmapT = 240.0f;

    public MiniMap() {
        this.player = this.mc.h;
        this.playerLocatorTex = TextureCache.instance().getPlayerLocatorSmall();
        PropertyManager pm = PropertyManager.getInstance();
        this.setEnabled(pm.getBoolean(PropertyManager.Key.PREF_SHOW_MINIMAP));
        this.setShowFps(pm.getBoolean(PropertyManager.Key.PREF_MINIMAP_SHOWFPS));
        this.state.fontScale = pm.getDouble(PropertyManager.Key.PREF_MINIMAP_FONTSCALE);
        DisplayVars.Shape shape = DisplayVars.Shape.valueOf(pm.getString(PropertyManager.Key.PREF_MINIMAP_SHAPE));
        DisplayVars.Position position = DisplayVars.Position.valueOf(pm.getString(PropertyManager.Key.PREF_MINIMAP_POSITION));
        this.updateDisplayVars(shape, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMap() {
        if (this.player == null) {
            this.player = this.mc.h;
            if (this.player == null) {
                return;
            }
        }
        boolean doStateRefresh = this.state.shouldRefresh(this.mc);
        this.drawTimer.start();
        try {
            if (doStateRefresh) {
                this.state.refresh(this.mc, this.player);
            }
            this.gridRenderer.setContext(this.state.getWorldDir(), this.state.getDimension());
            this.gridRenderer.center(this.mc.h.u, this.mc.h.w, this.state.currentZoom);
            this.gridRenderer.updateTextures(this.state.getMapType(), this.state.getVSlice(), this.mc.d, this.mc.e, doStateRefresh, 0.0, 0.0);
            if (doStateRefresh) {
                this.state.generateDrawSteps(this.mc, this.gridRenderer, this.waypointRenderer, this.radarRenderer, this.dv.drawScale);
                this.state.updateLastRefresh();
            }
            this.updateDisplayVars();
            JmUI.sizeDisplay(this.mc.d, this.mc.e);
            bma.a((int)bma.b, (float)this.lightmapS, (float)this.lightmapT);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            if (this.dv.maskTexture != null) {
                try {
                    GL11.glClear((int)256);
                    GL11.glEnable((int)2960);
                    GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    GL11.glDepthMask((boolean)false);
                    GL11.glStencilFunc((int)512, (int)1, (int)255);
                    GL11.glStencilOp((int)7681, (int)7680, (int)7680);
                    GL11.glStencilMask((int)255);
                    GL11.glClear((int)1024);
                    DrawUtil.drawQuad(this.dv.maskTexture, this.dv.textureX, this.dv.textureY, this.dv.maskTexture.width, this.dv.maskTexture.height, null, 1.0f, false, true, 770, 771);
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    GL11.glDepthMask((boolean)true);
                    GL11.glStencilMask((int)0);
                    GL11.glStencilFunc((int)514, (int)1, (int)255);
                }
                catch (Throwable t2) {
                    this.logger.warning("Stencil buffer failing with circle mask:" + LogFormatter.toString(t2));
                    this.drawTimer.stop();
                    return;
                }
            }
            GL11.glTranslated((double)this.dv.translateX, (double)this.dv.translateY, (double)0.0);
            GL11.glScissor((int)this.dv.scissorX, (int)this.dv.scissorY, (int)this.dv.minimapSize, (int)this.dv.minimapSize);
            GL11.glEnable((int)3089);
            this.gridRenderer.draw(1.0f, 0.0, 0.0);
            this.gridRenderer.draw(this.state.getDrawSteps(), 0, 0, this.dv.drawScale);
            this.playerPixel = this.gridRenderer.getPixel(this.mc.h.u, this.mc.h.w);
            if (this.playerPixel != null) {
                DrawUtil.drawEntity(this.playerPixel.getX(), this.playerPixel.getY(), EntityHelper.getHeading((nn)this.mc.h), false, this.playerLocatorTex, 8, 1.0f);
            }
            GL11.glTranslated((double)(-this.dv.translateX), (double)(-this.dv.translateY), (double)0.0);
            if (this.dv.maskTexture != null) {
                GL11.glDisable((int)2960);
            }
            GL11.glDisable((int)3089);
            int playerX = (int)this.player.u;
            int playerZ = (int)this.player.w;
            int playerY = (int)this.player.v;
            String playerInfo = Constants.getString("MapOverlay.player_location_minimap", playerX, playerZ, playerY, this.mc.h.ak, this.state.getPlayerBiome());
            double fontScale = this.dv.fontScale * (double)(this.mc.l.a() ? 2 : 1);
            double bottomY = (double)this.dv.bottomLabelY - (this.mc.l.a() ? fontScale * 4.0 : 0.0);
            if (fontScale > 1.0 && (double)this.mc.l.a(playerInfo) * fontScale > (double)this.dv.minimapSize) {
                playerInfo = Constants.getString("MapOverlay.player_location_minimap_nobiome", playerX, playerZ, playerY, this.mc.h.ak);
            }
            DrawUtil.drawCenteredLabel(playerInfo, this.dv.labelX, bottomY, this.playerInfoBgColor, this.playerInfoFgColor, 200, fontScale);
            if (this.showFps.booleanValue()) {
                int idx;
                String fps = this.mc.E;
                int n = idx = fps != null ? fps.indexOf(44) : -1;
                if (idx > 0) {
                    DrawUtil.drawCenteredLabel(fps.substring(0, idx), this.dv.labelX, this.dv.topLabelY, this.playerInfoBgColor, this.playerInfoFgColor, 200, fontScale);
                }
            }
            GL11.glEnable((int)2929);
            DrawUtil.drawImage(this.dv.borderTexture, this.dv.textureX, this.dv.textureY, false, 1.0f);
            GL11.glPopMatrix();
            JmUI.sizeDisplay(this.dv.scaledResolution.c(), this.dv.scaledResolution.d());
        }
        catch (Throwable t3) {
            this.logger.severe("Minimap error:" + LogFormatter.toString(t3));
        }
        finally {
            this.drawTimer.stop();
        }
    }

    public void reset() {
        this.state.requireRefresh();
        this.gridRenderer.clear();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = PropertyManager.getInstance().getBoolean(PropertyManager.Key.PREF_SHOW_MINIMAP) != false && !WaypointHelper.isReiLoaded() && !WaypointHelper.isVoxelMapLoaded();
        }
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        PropertyManager.getInstance().setProperty(PropertyManager.Key.PREF_SHOW_MINIMAP, enable);
    }

    public boolean isShowFps() {
        return this.showFps;
    }

    public void setShowFps(boolean enable) {
        this.showFps = enable;
    }

    public void nextPosition() {
        int nextIndex = this.dv.position.ordinal() + 1;
        if (nextIndex == DisplayVars.Position.values().length) {
            nextIndex = 0;
        }
        this.setPosition(DisplayVars.Position.values()[nextIndex]);
    }

    public DisplayVars.Position getPosition() {
        return this.dv.position;
    }

    public void setPosition(DisplayVars.Position position) {
        PropertyManager.set(PropertyManager.Key.PREF_MINIMAP_POSITION, position.name());
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.shape, position);
        }
    }

    public DisplayVars.Shape getShape() {
        return this.dv.shape;
    }

    public void setShape(DisplayVars.Shape shape) {
        if (this.dv != null) {
            this.updateDisplayVars(shape, this.dv.position);
        }
    }

    public void updateDisplayVars() {
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.shape, this.dv.position);
        }
    }

    public void updateDisplayVars(DisplayVars.Shape shape, DisplayVars.Position position) {
        if (this.dv != null && this.mc.e == this.dv.displayHeight && this.mc.d == this.dv.displayWidth && this.dv.shape == shape && this.dv.position == position && this.dv.fontScale == this.state.fontScale) {
            return;
        }
        DisplayVars oldDv = this.dv;
        this.dv = new DisplayVars(this.mc, shape, position, this.state.fontScale);
        if (oldDv == null || oldDv.shape != this.dv.shape) {
            this.drawTimer = StatTimer.get("MiniMap.drawMap." + shape.name(), 200);
        }
        if (oldDv == null || oldDv.shape != this.dv.shape) {
            // empty if block
        }
        this.gridRenderer.setViewPort(new Point2D.Double(this.dv.scissorX, this.dv.scissorY + this.dv.minimapSize), this.dv.minimapSize);
    }
}

