/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.minimap;

import java.util.Arrays;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MapButton;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.minimap.DisplayVars;
import net.techbrew.journeymap.ui.minimap.MiniMap;

public class MiniMapOptions
extends JmUI {
    private MapButton buttonPosition;
    private MapButton buttonShape;
    private MapButton buttonFont;
    private MapButton buttonMiniMap;
    private MapButton buttonKeyboard;
    private MapButton buttonKeyboardHelp;
    private MapButton buttonShowfps;
    private MapButton buttonClose;
    private MapButton buttonCloseAll;
    private DisplayVars.Shape currentShape;
    private DisplayVars.Position currentPosition;

    public MiniMapOptions() {
        super(Constants.getString("MiniMap.options"));
    }

    @Override
    public void A_() {
        this.i.clear();
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        PropertyManager pm = PropertyManager.getInstance();
        boolean minimapOn = pm.getBoolean(PropertyManager.Key.PREF_SHOW_MINIMAP);
        this.buttonMiniMap = new MapButton(ButtonEnum.MiniMap.ordinal(), 0, 0, Constants.getString("MiniMap.enable_minimap", on), Constants.getString("MiniMap.enable_minimap", off), minimapOn);
        this.buttonMiniMap.setToggled(minimapOn);
        DisplayVars.Position position = DisplayVars.Position.valueOf(pm.getString(PropertyManager.Key.PREF_MINIMAP_POSITION));
        this.buttonPosition = new MapButton(ButtonEnum.Position.ordinal(), 0, 0, "");
        this.setPosition(position);
        this.buttonPosition.h = minimapOn;
        DisplayVars.Shape shape = DisplayVars.Shape.valueOf(pm.getString(PropertyManager.Key.PREF_MINIMAP_SHAPE));
        this.buttonShape = new MapButton(ButtonEnum.Shape.ordinal(), 0, 0, "");
        this.setShape(shape);
        this.buttonShape.h = minimapOn;
        MapOverlay.state().fontScale = pm.getDouble(PropertyManager.Key.PREF_MINIMAP_FONTSCALE);
        this.buttonFont = new MapButton(ButtonEnum.Font.ordinal(), 0, 0, Constants.getString("MiniMap.font", Constants.getString("MiniMap.font_small")), Constants.getString("MiniMap.font", Constants.getString("MiniMap.font_large")), MapOverlay.state().fontScale == 1.0);
        this.buttonFont.h = minimapOn;
        boolean showHotKeys = pm.getBoolean(PropertyManager.Key.PREF_MINIMAP_HOTKEYS);
        this.buttonKeyboard = new MapButton(ButtonEnum.Keyboard.ordinal(), 0, 0, Constants.getString("MiniMap.hotkeys", on), Constants.getString("MiniMap.hotkeys", off), showHotKeys);
        this.buttonKeyboardHelp = new MapButton(ButtonEnum.KeyboardHelp.ordinal(), 0, 0, Constants.getString("MapOverlay.hotkeys_button"));
        boolean isShowFps = pm.getBoolean(PropertyManager.Key.PREF_MINIMAP_SHOWFPS);
        this.buttonShowfps = new MapButton(ButtonEnum.Showfps.ordinal(), 0, 0, Constants.getString("MiniMap.show_fps", on), Constants.getString("MiniMap.show_fps", off), isShowFps);
        this.buttonShowfps.h = minimapOn;
        this.buttonClose = new MapButton(ButtonEnum.Close.ordinal(), 0, 0, Constants.getString("MapOverlay.close"));
        this.buttonCloseAll = new MapButton(ButtonEnum.CloseAll.ordinal(), 0, 0, Constants.getString("MiniMap.return_to_game"));
        this.i.add(this.buttonMiniMap);
        this.i.add(this.buttonPosition);
        this.i.add(this.buttonShape);
        this.i.add(this.buttonFont);
        this.i.add(this.buttonKeyboard);
        this.i.add(this.buttonKeyboardHelp);
        this.i.add(this.buttonShowfps);
        this.i.add(this.buttonClose);
        this.i.add(this.buttonCloseAll);
    }

    @Override
    protected void layoutButtons() {
        if (this.i.isEmpty()) {
            this.A_();
        }
        int hgap = 4;
        int vgap = 3;
        int bx = (this.g - 4) / 2;
        int by2 = this.h / 4;
        this.buttonMiniMap.leftOf(bx).setY(by2);
        this.buttonShape.rightOf(this.buttonMiniMap, 4).setY(by2);
        this.buttonPosition.below(this.buttonMiniMap, 3).leftOf(bx);
        this.buttonFont.below(this.buttonShape, 3).rightOf(this.buttonPosition, 4);
        this.buttonKeyboard.below(this.buttonPosition, 3).leftOf(bx);
        this.buttonShowfps.below(this.buttonFont, 3).rightOf(this.buttonKeyboard, 4);
        this.buttonKeyboardHelp.below(this.buttonKeyboard, 3).centerHorizontalOn(this.g / 2);
        this.buttonClose.below(this.buttonKeyboardHelp, 3).centerHorizontalOn(this.g / 2);
        this.buttonCloseAll.below(this.buttonClose, 3).centerHorizontalOn(this.g / 2);
    }

    @Override
    protected void a(aut guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.g];
        switch (id) {
            case MiniMap: {
                UIManager uim = UIManager.getInstance();
                boolean enabled = !uim.isMiniMapEnabled();
                PropertyManager.set(PropertyManager.Key.PREF_SHOW_MINIMAP, enabled);
                this.buttonMiniMap.setToggled(enabled);
                uim.setMiniMapEnabled(enabled);
                this.buttonPosition.h = enabled;
                this.buttonShape.h = enabled;
                this.buttonFont.h = enabled;
                this.buttonShowfps.h = enabled;
                break;
            }
            case Shape: {
                this.nextShape();
                break;
            }
            case Position: {
                this.nextPosition();
                break;
            }
            case Font: {
                double newScale;
                MapOverlay.state().fontScale = newScale = MapOverlay.state().fontScale == 1.0 ? 2.0 : 1.0;
                PropertyManager.set(PropertyManager.Key.PREF_MINIMAP_FONTSCALE, newScale);
                this.buttonFont.setToggled(newScale == 1.0);
                UIManager.getInstance().getMiniMap().updateDisplayVars();
                break;
            }
            case Keyboard: {
                boolean showHotKeys = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_MINIMAP_HOTKEYS) == false;
                this.buttonKeyboard.setToggled(showHotKeys);
                PropertyManager.set(PropertyManager.Key.PREF_MINIMAP_HOTKEYS, showHotKeys);
                break;
            }
            case KeyboardHelp: {
                UIManager.getInstance().openMiniMapHotkeyHelp();
                break;
            }
            case Showfps: {
                boolean showFps = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_MINIMAP_SHOWFPS) == false;
                this.buttonShowfps.setToggled(showFps);
                UIManager.getInstance().getMiniMap().setShowFps(showFps);
                PropertyManager.set(PropertyManager.Key.PREF_MINIMAP_SHOWFPS, showFps);
                break;
            }
            case Close: {
                UIManager.getInstance().openMapOptions();
                break;
            }
            case CloseAll: {
                UIManager.getInstance().closeAll();
            }
        }
    }

    public void nextShape() {
        int nextIndex = this.currentShape.ordinal() + 1;
        if (nextIndex == DisplayVars.Shape.Enabled.length) {
            nextIndex = 0;
        }
        this.setShape(DisplayVars.Shape.Enabled[nextIndex]);
    }

    private void setShape(DisplayVars.Shape shape) {
        if (Arrays.binarySearch((Object[])DisplayVars.Shape.Enabled, (Object)shape) < 0) {
            shape = DisplayVars.Shape.Enabled[0];
        }
        this.currentShape = shape;
        this.buttonShape.f = Constants.getString("MiniMap.shape", Constants.getString(this.currentShape.label));
        UIManager.getInstance().getMiniMap().setShape(shape);
        PropertyManager.set(PropertyManager.Key.PREF_MINIMAP_SHAPE, shape.name());
    }

    private void nextPosition() {
        int nextIndex = this.currentPosition.ordinal() + 1;
        if (nextIndex == DisplayVars.Position.values().length) {
            nextIndex = 0;
        }
        this.setPosition(DisplayVars.Position.values()[nextIndex]);
    }

    private void setPosition(DisplayVars.Position position) {
        this.currentPosition = position;
        this.buttonPosition.f = Constants.getString("MiniMap.position", Constants.getString(this.currentPosition.label));
        UIManager.getInstance().getMiniMap().setPosition(position);
    }

    @Override
    public void c(int layer) {
        super.c(layer);
        MiniMap miniMap = UIManager.getInstance().getMiniMap();
        if (miniMap.isEnabled()) {
            miniMap.drawMap();
        }
    }

    @Override
    protected void a(char c, int i) {
        switch (i) {
            case 1: {
                UIManager.getInstance().openMap();
            }
        }
    }

    private static enum ButtonEnum {
        MiniMap,
        Position,
        Shape,
        Font,
        Keyboard,
        KeyboardHelp,
        Close,
        Showfps,
        CloseAll;

    }
}

