/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import java.util.logging.Level;
import net.minecraft.init.Blocks;
import net.minecraft.world.EnumSkyBlock;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.BaseRenderer;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class ChunkStandardRenderer
extends BaseRenderer
implements IChunkRenderer {
    static final int alphaDepth = 5;

    @Override
    public boolean render(Graphics2D g2D, ChunkMD chunkMd, boolean underground, Integer vSlice, ChunkMD.Set neighbors) {
        if (chunkMd.surfaceSlopes == null) {
            this.initSurfaceSlopes(chunkMd, neighbors);
        }
        if (underground) {
            int hardSliceMaxY;
            int sliceMaxY;
            int sliceMinY;
            boolean ok = this.renderSurface(g2D, chunkMd, vSlice, neighbors, true);
            if (!ok) {
                JourneyMap.getLogger().fine("The surface chunk didn't paint: " + chunkMd.toString());
            }
            if ((sliceMinY = Math.max((vSlice << 4) - 1, 0)) == (sliceMaxY = Math.min(hardSliceMaxY = (vSlice + 1 << 4) - 1, chunkMd.worldObj.func_72940_L()))) {
                sliceMaxY += 2;
            }
            if (chunkMd.sliceSlopes == null) {
                this.initSliceSlopes(chunkMd, sliceMinY, sliceMaxY, neighbors);
            }
            if (!(ok = this.renderUnderground(g2D, chunkMd, vSlice, sliceMinY, sliceMaxY, neighbors))) {
                JourneyMap.getLogger().fine("The underground chunk didn't paint: " + chunkMd.toString());
            }
            return ok;
        }
        return this.renderSurface(g2D, chunkMd, vSlice, neighbors, false);
    }

    private void initSurfaceSlopes(ChunkMD chunkMd, ChunkMD.Set neighbors) {
        chunkMd.surfaceSlopes = new float[16][16];
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                float slope;
                float h = chunkMd.getSlopeHeightValue(x, y);
                float hN = y == 0 ? this.getBlockHeight(x, y, 0, -1, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x, y - 1);
                float hW = x == 0 ? this.getBlockHeight(x, y, -1, 0, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x - 1, y);
                chunkMd.surfaceSlopes[x][y] = slope = (h / hN + h / hW) / 2.0f;
            }
        }
    }

    private void initSliceSlopes(ChunkMD chunkMd, int sliceMinY, int sliceMaxY, ChunkMD.Set neighbors) {
        chunkMd.sliceSlopes = new float[16][16];
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                float slope;
                float h = this.getHeightInSlice(chunkMd, x, z, sliceMinY, sliceMaxY);
                float hN = z == 0 ? this.getBlockHeight(x, z, 0, -1, chunkMd, neighbors, h, sliceMinY, sliceMaxY).floatValue() : (float)this.getHeightInSlice(chunkMd, x, z - 1, sliceMinY, sliceMaxY);
                float hW = x == 0 ? this.getBlockHeight(x, z, -1, 0, chunkMd, neighbors, h, sliceMinY, sliceMaxY).floatValue() : (float)this.getHeightInSlice(chunkMd, x - 1, z, sliceMinY, sliceMaxY);
                chunkMd.sliceSlopes[x][z] = slope = (h / hN + h / hW) / 2.0f;
            }
        }
    }

    private boolean renderSurface(Graphics2D g2D, ChunkMD chunkMd, Integer vSlice, ChunkMD.Set neighbors, boolean forUndergroundLayer) {
        StatTimer timer = StatTimer.get("ChunkStandardRenderer.renderSurface");
        timer.start();
        g2D.setComposite(BlockUtils.OPAQUE);
        boolean chunkOk = false;
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                float diff;
                BlockMD blockMD;
                int y = Math.max(1, chunkMd.stub.func_76611_b(x, z));
                do {
                    if ((blockMD = BlockMD.getBlockMD(chunkMd, x, y, z)) != null) continue;
                    this.paintBadBlock(x, y, z, g2D);
                    continue block1;
                } while (blockMD.isAir() && --y >= 0);
                RGB color = blockMD.getColor(chunkMd, x, y, z);
                if (color == null) {
                    this.paintBadBlock(x, y, z, g2D);
                    continue;
                }
                boolean useAlpha = blockMD.hasFlag(BlockUtils.Flag.Transparency);
                if (!forUndergroundLayer && useAlpha) {
                    color = this.renderSurfaceAlpha(g2D, chunkMd, blockMD, neighbors, x, y, z);
                } else {
                    if (!blockMD.hasFlag(BlockUtils.Flag.NoShadow)) {
                        this.surfaceSlopeColor(color, chunkMd, blockMD, neighbors, x, y, z);
                    }
                    if (forUndergroundLayer) {
                        color.ghostSurface();
                    }
                    g2D.setPaint(color.toColor());
                    g2D.fillRect(x, z, 1, 1);
                    chunkOk = true;
                }
                if (forUndergroundLayer) continue;
                int lightLevel = Math.max(1, chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, y + 1, z));
                if (lightLevel < 15 && (double)(diff = Math.min(1.0f, (float)lightLevel / 15.0f + 0.1f)) != 1.0) {
                    color.moonlight(diff);
                }
                g2D.setPaint(color.toColor());
                g2D.fillRect(x + 16, z, 1, 1);
                chunkOk = true;
            }
        }
        timer.stop();
        return chunkOk;
    }

    private RGB renderSurfaceAlpha(Graphics2D g2D, ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int y, int z) {
        RGB color = blockMD.getColor(chunkMd, x, y, z);
        if (blockMD.isWater()) {
            BlockMD bw = this.getBlock(x, y, z, -1, 0, chunkMd, neighbors, blockMD);
            BlockMD be = this.getBlock(x, y, z, 1, 0, chunkMd, neighbors, blockMD);
            BlockMD bn = this.getBlock(x, y, z, 0, -1, chunkMd, neighbors, blockMD);
            BlockMD bs = this.getBlock(x, y, z, 0, 1, chunkMd, neighbors, blockMD);
            HashSet<RGB> colors = new HashSet<RGB>(5);
            colors.add(color);
            if (bw.isWater()) {
                colors.add(bw.getColor(chunkMd, x, y, z));
            }
            if (be.isWater()) {
                colors.add(be.getColor(chunkMd, x, y, z));
            }
            if (bn.isWater()) {
                colors.add(bn.getColor(chunkMd, x, y, z));
            }
            if (bs.isWater()) {
                colors.add(bs.getColor(chunkMd, x, y, z));
            }
            if (!colors.isEmpty()) {
                color = RGB.average(colors);
            }
        }
        this.paintDepth(chunkMd, blockMD, x, y, z, g2D, false);
        return color;
    }

    private void surfaceSlopeColor(RGB color, ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int ignored, int z) {
        float sAvg;
        float slope = chunkMd.surfaceSlopes[x][z];
        if (!blockMD.isFoliage()) {
            float sN = this.getBlockSlope(x, z, 0, -1, chunkMd, neighbors, slope, false).floatValue();
            float sNW = this.getBlockSlope(x, z, -1, -1, chunkMd, neighbors, slope, false).floatValue();
            float sW = this.getBlockSlope(x, z, -1, 0, chunkMd, neighbors, slope, false).floatValue();
            sAvg = (sN + sNW + sW) / 3.0f;
        } else {
            float sN = this.getBlockSlope(x, z, 0, -1, chunkMd, neighbors, slope, false).floatValue();
            float sS = this.getBlockSlope(x, z, 0, 1, chunkMd, neighbors, slope, false).floatValue();
            float sW = this.getBlockSlope(x, z, -1, 0, chunkMd, neighbors, slope, false).floatValue();
            float sE = this.getBlockSlope(x, z, 1, 0, chunkMd, neighbors, slope, false).floatValue();
            sAvg = (sN + sS + sW + sE) / 4.0f;
        }
        float bevel = 1.0f;
        if (slope < 1.0f) {
            if (slope <= sAvg) {
                slope *= 0.6f;
            } else if (slope > sAvg && !blockMD.isFoliage()) {
                slope = (slope + sAvg) / 2.0f;
            }
            bevel = Math.max(slope * 0.8f, 0.1f);
        } else if (slope > 1.0f) {
            if (sAvg > 1.0f && slope >= sAvg && !blockMD.isFoliage()) {
                slope *= 1.2f;
            }
            bevel = Math.min(slope * 1.2f, 1.4f);
        }
        if (bevel != 1.0f) {
            color.bevelSlope(bevel);
        }
    }

    public boolean renderUnderground(Graphics2D g2D, ChunkMD chunkMd, int vSlice, int sliceMinY, int sliceMaxY, ChunkMD.Set neighbors) {
        boolean chunkOk = false;
        for (int z = 0; z < 16; ++z) {
            block3: for (int x = 0; x < 16; ++x) {
                boolean hasAir = false;
                boolean hasWater = false;
                int paintY = -1;
                int lightLevel = 0;
                try {
                    int blockMaxY = BlockUtils.ceiling(chunkMd, x, sliceMaxY, z);
                    int checkY = Math.min(sliceMaxY - 1, blockMaxY + 1);
                    if (BlockUtils.skyAbove(chunkMd, x, checkY, z)) {
                        chunkOk = true;
                        continue;
                    }
                    BlockMD info = BlockMD.getBlockMD(chunkMd, x, blockMaxY + 1, z);
                    hasAir = info.isAir();
                    hasWater = info.isWater();
                    paintY = blockMaxY;
                    for (int y = blockMaxY; y >= 0; --y) {
                        info = BlockMD.getBlockMD(chunkMd, x, y, z);
                        if (info.isWater()) {
                            hasWater = true;
                            this.paintDepth(chunkMd, BlockMD.getBlockMD(chunkMd, x, y, z), x, y, z, g2D, true);
                            continue block3;
                        }
                        if (info.isAir()) {
                            hasAir = true;
                            continue;
                        }
                        if (info.isTorch()) {
                            hasAir = true;
                            if (chunkMd.stub.func_76628_c(x, y, z) != 5) {
                                continue;
                            }
                        } else if (info.isLava()) {
                            if (!hasAir) {
                                this.paintBlock(x, z, Color.black, g2D);
                                continue block3;
                            }
                            lightLevel = 15;
                            paintY = y;
                            break;
                        }
                        if (hasAir) {
                            paintY = y;
                            if (!this.caveLighting || (lightLevel = chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, paintY + 1, z)) > 0) break;
                            hasAir = false;
                            continue;
                        }
                        if (y <= sliceMinY) break;
                    }
                    if (paintY < 0 || !hasAir && !hasWater || lightLevel < 1 && this.caveLighting) {
                        this.paintBlock(x, z, Color.black, g2D);
                        chunkOk = true;
                        continue;
                    }
                    info = BlockMD.getBlockMD(chunkMd, x, paintY, z);
                    RGB color = info.getColor(chunkMd, x, paintY, z);
                    boolean keepflat = info.hasFlag(BlockUtils.Flag.NoShadow);
                    if (!keepflat) {
                        float s;
                        float slope = chunkMd.sliceSlopes[x][z];
                        float sN = this.getBlockSlope(x, z, 0, -1, chunkMd, neighbors, slope, true).floatValue();
                        float sNW = this.getBlockSlope(x, z, -1, -1, chunkMd, neighbors, slope, true).floatValue();
                        float sW = this.getBlockSlope(x, z, -1, 0, chunkMd, neighbors, slope, true).floatValue();
                        float sAvg = (sN + sNW + sW) / 3.0f;
                        if (slope < 1.0f) {
                            if (slope <= sAvg) {
                                slope *= 0.6f;
                            } else if (slope > sAvg) {
                                slope = (slope + sAvg) / 2.0f;
                            }
                            s = Math.max(slope * 0.8f, 0.1f);
                            color.bevelSlope(s);
                        } else if (slope > 1.0f) {
                            if (sAvg > 1.0f && slope >= sAvg) {
                                slope *= 1.2f;
                            }
                            s = slope * 1.2f;
                            s = Math.min(s, 1.4f);
                            color.bevelSlope(s);
                        }
                    }
                    if (this.caveLighting && lightLevel < 15) {
                        float factor = Math.min(1.0f, (float)lightLevel / 16.0f);
                        color.darken(factor);
                    }
                    this.paintBlock(x, z, color.toColor(), g2D);
                    chunkOk = true;
                    continue;
                }
                catch (Throwable t) {
                    this.paintBadBlock(x, vSlice, z, g2D);
                    String error = Constants.getMessageJMERR07("x,vSlice,z = " + x + "," + vSlice + "," + z + " : " + t.getMessage());
                    JourneyMap.getLogger().severe(error);
                    JourneyMap.getLogger().log(Level.SEVERE, LogFormatter.toString(t));
                }
            }
        }
        return chunkOk;
    }

    private void paintDepth(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z, Graphics2D g2D, boolean useLighting) {
        BlockMD lowerBlock;
        Stack<BlockMD> stack = new Stack<BlockMD>();
        stack.push(blockMD);
        int maxDepth = 5;
        int down = y;
        while (down > 0 && (lowerBlock = BlockMD.getBlockMD(chunkMd, x, --down, z)) != null) {
            stack.push(lowerBlock);
            if (lowerBlock.isWater() || lowerBlock.getBlock() == Blocks.field_150432_aD) {
                maxDepth = 4;
            } else if (lowerBlock.isAir()) {
                maxDepth = 256;
            }
            if (lowerBlock.getAlpha() != 1.0f && y - down <= maxDepth) continue;
            break;
        }
        boolean isWater = blockMD.isWater();
        RGB color = ((BlockMD)stack.peek()).getColor(chunkMd, x, down, z);
        if (useLighting) {
            float diff;
            int lightLevel = chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, down + 1, z);
            if (lightLevel < 15 && (double)(diff = Math.min(1.0f, (float)lightLevel / 15.0f + 0.05f)) != 1.0) {
                color.moonlight(diff);
            }
        } else if (isWater) {
            float factor = 0.68f;
            color.darken(factor);
        }
        g2D.setComposite(BlockUtils.OPAQUE);
        g2D.setPaint(color.toColor());
        g2D.fillRect(x, z, 1, 1);
        if (((BlockMD)stack.peek()).getBlock() != blockMD.getBlock()) {
            stack.pop();
            ArrayList<RGB> colors = new ArrayList<RGB>();
            colors.add(color);
            while (!stack.isEmpty()) {
                BlockMD lowerBlock2 = (BlockMD)stack.pop();
                color = lowerBlock2.getColor(chunkMd, x, down, z);
                if (useLighting) {
                    float diff;
                    int lightLevel;
                    if ((lightLevel = chunkMd.getSavedLightValue(EnumSkyBlock.Block, x, ++down, z)) < 15 && (double)(diff = Math.min(1.0f, (float)lightLevel / 15.0f + 0.05f)) != 1.0) {
                        color.moonlight(diff);
                    }
                } else if (isWater) {
                    float factor = 0.7f;
                    color.darken(factor);
                }
                colors.add(color);
            }
            g2D.setComposite(BlockUtils.OPAQUE);
            g2D.setPaint(RGB.average(colors).toColor());
            g2D.fillRect(x, z, 1, 1);
        }
    }

    public int getHeightInSlice(ChunkMD chunkMd, int x, int z, int sliceMinY, int sliceMaxY) {
        return BlockUtils.ceiling(chunkMd, x, sliceMaxY, z) + 1;
    }

    public Float getBlockHeight(int x, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors, float defaultVal, int sliceMinY, int sliceMaxY) {
        int newX = x + offsetX;
        int newZ = z + offsetz;
        int chunkX = currentChunk.stub.field_76635_g;
        int chunkZ = currentChunk.stub.field_76647_h;
        boolean search = false;
        if (newX == -1) {
            --chunkX;
            newX = 15;
            search = true;
        } else if (newX == 16) {
            ++chunkX;
            newX = 0;
            search = true;
        }
        if (newZ == -1) {
            --chunkZ;
            newZ = 15;
            search = true;
        } else if (newZ == 16) {
            ++chunkZ;
            newZ = 0;
            search = true;
        }
        ChunkMD chunk = this.getChunk(x, z, offsetX, offsetz, currentChunk, neighbors);
        if (chunk != null) {
            return Float.valueOf(this.getHeightInSlice(chunk, newX, newZ, sliceMinY, sliceMaxY));
        }
        return Float.valueOf(defaultVal);
    }
}

