/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.techbrew.journeymap.data.AnimalsData;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.data.ImagesData;
import net.techbrew.journeymap.data.MobsData;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.data.PlayersData;
import net.techbrew.journeymap.data.VillagersData;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.model.WaypointHelper;

public class AllData
implements IDataProvider {
    private final long TTL = PropertyManager.getInstance().getInteger(PropertyManager.Key.BROWSER_POLL).intValue();

    @Override
    public Enum[] getKeys() {
        return Key.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        DataCache cache = DataCache.instance();
        LinkedHashMap props = new LinkedHashMap();
        props.put(Key.world, cache.get(WorldData.class));
        props.put(Key.images, cache.get(ImagesData.class, optionalParams));
        props.put(Key.player, cache.get(PlayerData.class));
        if (WaypointHelper.waypointsEnabled() && PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_WAYPOINTS).booleanValue()) {
            props.put(Key.waypoints, cache.get(WaypointsData.class).get((Object)EntityKey.root));
        } else {
            props.put(Key.waypoints, Collections.emptyMap());
        }
        if (!WorldData.isHardcoreAndMultiplayer()) {
            if (PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_ANIMALS).booleanValue()) {
                props.put(Key.animals, cache.get(AnimalsData.class).get((Object)EntityKey.root));
            } else {
                props.put(Key.animals, Collections.emptyMap());
            }
            if (PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_MOBS).booleanValue()) {
                props.put(Key.mobs, cache.get(MobsData.class).get((Object)EntityKey.root));
            } else {
                props.put(Key.mobs, Collections.emptyMap());
            }
            if (PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_PLAYERS).booleanValue()) {
                props.put(Key.players, cache.get(PlayersData.class).get((Object)EntityKey.root));
            } else {
                props.put(Key.players, Collections.emptyMap());
            }
            if (PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_VILLAGERS).booleanValue()) {
                props.put(Key.villagers, cache.get(VillagersData.class).get((Object)EntityKey.root));
            } else {
                props.put(Key.villagers, Collections.emptyMap());
            }
        }
        return props;
    }

    @Override
    public long getTTL() {
        return this.TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }

    public static enum Key {
        animals,
        images,
        mobs,
        player,
        players,
        villagers,
        waypoints,
        world;

    }
}

