/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.util.StringUtils;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.model.EntityHelper;

public class AnimalsData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(3L);
    private final boolean includeNonPets;
    private final boolean includePets;

    public AnimalsData() {
        this.includeNonPets = true;
        this.includePets = true;
    }

    public AnimalsData(boolean includeNonPets, boolean includePets) {
        this.includeNonPets = includeNonPets;
        this.includePets = includePets;
    }

    @Override
    public Enum[] getKeys() {
        return EntityKey.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        if (!FeatureManager.isAllowed(Feature.RadarAnimals)) {
            return Collections.emptyMap();
        }
        List<IAnimals> animals = EntityHelper.getAnimalsNearby();
        ArrayList<LinkedHashMap> list = new ArrayList<LinkedHashMap>(animals.size());
        for (IAnimals animal : animals) {
            String owner;
            EntityLiving entity = (EntityLiving)animal;
            if (entity.field_70153_n != null) continue;
            LinkedHashMap<EntityKey, Object> eProps = new LinkedHashMap<EntityKey, Object>();
            eProps.put(EntityKey.entityId, entity.func_110124_au());
            eProps.put(EntityKey.filename, EntityHelper.getFileName((Entity)entity));
            eProps.put(EntityKey.hostile, false);
            eProps.put(EntityKey.posX, entity.field_70165_t);
            eProps.put(EntityKey.posZ, entity.field_70161_v);
            eProps.put(EntityKey.chunkCoordX, entity.field_70176_ah);
            eProps.put(EntityKey.chunkCoordZ, entity.field_70164_aj);
            eProps.put(EntityKey.heading, EntityHelper.getHeading((Entity)entity));
            if (entity instanceof EntityTameable) {
                owner = ((EntityTameable)entity).func_70905_p();
                if (owner != null) {
                    eProps.put(EntityKey.owner, owner);
                }
            } else if (entity instanceof EntityHorse) {
                owner = entity.func_70096_w().func_75681_e(21);
                eProps.put(EntityKey.owner, owner);
            }
            if (entity.func_94056_bM()) {
                eProps.put(EntityKey.customName, StringUtils.func_76338_a((String)entity.func_94057_bL()));
            }
            list.add(eProps);
        }
        LinkedHashMap<EntityKey, Map<Object, Map>> props = new LinkedHashMap<EntityKey, Map<Object, Map>>();
        props.put(EntityKey.root, EntityHelper.buildEntityIdMap(list, true));
        return props;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }
}

