/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.io.JsonHelper;
import net.techbrew.journeymap.log.LogFormatter;

public class DataCache {
    private final ConcurrentHashMap<Class<? extends IDataProvider>, DataHolder> cache = new ConcurrentHashMap(8);

    private DataCache() {
    }

    public static DataCache instance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        ConcurrentHashMap<Class<? extends IDataProvider>, DataHolder> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            this.cache.clear();
        }
    }

    public void put(IDataProvider dp, Map optionalParams) {
        this.putInternal(dp, optionalParams);
    }

    private DataHolder putInternal(Class<? extends IDataProvider> dpClass, Map optionalParams) {
        try {
            return this.putInternal(dpClass.newInstance(), optionalParams);
        }
        catch (Exception e) {
            JourneyMap.getLogger().severe("Can't instantiate dataprovider " + dpClass + " for cache: " + LogFormatter.toString(e));
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataHolder putInternal(IDataProvider dp, Map optionalParams) {
        ConcurrentHashMap<Class<? extends IDataProvider>, DataHolder> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            if (JourneyMap.getLogger().isLoggable(Level.FINER)) {
                JourneyMap.getLogger().finer("Caching " + dp.getClass().getName());
            }
            DataHolder dh = new DataHolder(dp, optionalParams);
            this.cache.put(dp.getClass(), dh);
            return dh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataHolder internalGet(Class<? extends IDataProvider> dpClass, Map optionalParams) {
        ConcurrentHashMap<Class<? extends IDataProvider>, DataHolder> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            DataHolder dh = this.cache.get(dpClass);
            if (dh == null || dh.hasExpired()) {
                dh = this.putInternal(dpClass, optionalParams);
            }
            return dh;
        }
    }

    public Map get(Class<? extends IDataProvider> dpClass) {
        return this.internalGet(dpClass, null).getData();
    }

    public Map get(Class<? extends IDataProvider> dpClass, Map optionalParams) {
        return this.internalGet(dpClass, optionalParams).getData();
    }

    public String getJson(Class<? extends IDataProvider> dpClass, Map optionalParams) {
        return this.internalGet(dpClass, optionalParams).getJsonData();
    }

    public long appendJson(Class<? extends IDataProvider> dpClass, Map optionalParams, StringBuffer sb) {
        DataHolder dh = this.internalGet(dpClass, optionalParams);
        sb.append(dh.getJsonData());
        return dh.getExpires();
    }

    public static Object playerDataValue(EntityKey key) {
        return DataCache.instance().get(PlayerData.class, null).get((Object)key);
    }

    private class DataHolder {
        private final IDataProvider dp;
        private final long expires;
        private final Map data;
        private final String jsonData;

        DataHolder(IDataProvider dp, Map optionalParams) {
            this.dp = dp;
            this.data = Collections.unmodifiableMap(dp.getMap(optionalParams));
            this.jsonData = JsonHelper.toJson(this.data);
            this.expires = System.currentTimeMillis() + dp.getTTL();
        }

        public long getExpires() {
            return this.expires;
        }

        public boolean hasExpired() {
            return this.dp.dataExpired() || this.expires <= System.currentTimeMillis();
        }

        public Map getData() {
            return this.data;
        }

        public String getJsonData() {
            return this.jsonData;
        }
    }

    private static class Holder {
        private static final DataCache INSTANCE = new DataCache();

        private Holder() {
        }
    }
}

