/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.model.WaypointHelper;
import org.lwjgl.opengl.Display;

public class GameData
implements IDataProvider {
    private static long TTL = TimeUnit.HOURS.toMillis(1L);

    @Override
    public Enum[] getKeys() {
        return Key.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        PropertyManager pm = PropertyManager.getInstance();
        LinkedHashMap<Key, Object> props = new LinkedHashMap<Key, Object>();
        props.put(Key.mod_name, JourneyMap.MOD_NAME);
        props.put(Key.jm_version, "3.3.0");
        props.put(Key.latest_journeymap_version, VersionCheck.getVersionAvailable());
        props.put(Key.mc_version, Display.getTitle().split("\\s(?=\\d)")[1]);
        props.put(Key.browser_poll, pm.getInteger(PropertyManager.Key.BROWSER_POLL));
        props.put(Key.waypoints_enabled, WaypointHelper.waypointsEnabled());
        return props;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }

    public static enum Key {
        jm_version,
        latest_journeymap_version,
        mc_version,
        mod_name,
        browser_poll,
        waypoints_enabled;

    }
}

