/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.StringUtils;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.model.EntityHelper;

public class MobsData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(3L);

    @Override
    public Enum[] getKeys() {
        return EntityKey.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        if (!FeatureManager.isAllowed(Feature.RadarMobs)) {
            return Collections.emptyMap();
        }
        List mobs = EntityHelper.getMobsNearby();
        ArrayList<LinkedHashMap> list = new ArrayList<LinkedHashMap>(mobs.size());
        for (Object mob : mobs) {
            if (!(mob instanceof Entity)) continue;
            Entity entity = (Entity)mob;
            LinkedHashMap<EntityKey, Object> eProps = new LinkedHashMap<EntityKey, Object>();
            eProps.put(EntityKey.entityId, entity.func_110124_au());
            eProps.put(EntityKey.filename, EntityHelper.getFileName(entity));
            eProps.put(EntityKey.hostile, true);
            eProps.put(EntityKey.posX, entity.field_70165_t);
            eProps.put(EntityKey.posZ, entity.field_70161_v);
            eProps.put(EntityKey.chunkCoordX, entity.field_70176_ah);
            eProps.put(EntityKey.chunkCoordZ, entity.field_70164_aj);
            eProps.put(EntityKey.heading, EntityHelper.getHeading(entity));
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_94056_bM()) {
                eProps.put(EntityKey.customName, StringUtils.func_76338_a((String)((EntityLiving)entity).func_94057_bL()));
            }
            list.add(eProps);
        }
        LinkedHashMap<EntityKey, Map<Object, Map>> props = new LinkedHashMap<EntityKey, Map<Object, Map>>();
        props.put(EntityKey.root, EntityHelper.buildEntityIdMap(list, true));
        return props;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }
}

