/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.EntityHelper;

public class PlayerData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(1L);

    @Override
    public Enum[] getKeys() {
        return EntityKey.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        LinkedHashMap<EntityKey, Object> props = new LinkedHashMap<EntityKey, Object>();
        props.put(EntityKey.entityId, player.func_110124_au());
        props.put(EntityKey.username, player.getDisplayName());
        props.put(EntityKey.heading, EntityHelper.getHeading((Entity)player));
        props.put(EntityKey.chunkCoordX, player.field_70176_ah);
        props.put(EntityKey.chunkCoordY, player.field_70162_ai);
        props.put(EntityKey.chunkCoordZ, player.field_70164_aj);
        props.put(EntityKey.posX, player.field_70165_t);
        props.put(EntityKey.posY, player.field_70163_u);
        props.put(EntityKey.posZ, player.field_70161_v);
        props.put(EntityKey.dimension, mc.field_71441_e.field_73011_w.field_76574_g);
        props.put(EntityKey.biome, this.getPlayerBiome());
        props.put(EntityKey.underground, PlayerData.playerIsUnderground((EntityPlayer)player));
        return props;
    }

    private String getPlayerBiome() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        int x = (int)Math.floor(player.field_70165_t) % 16 & 0xF;
        int z = (int)Math.floor(player.field_70161_v) % 16 & 0xF;
        ChunkMD playerChunk = ChunkLoader.getChunkStubFromMemory(player.field_70176_ah, player.field_70164_aj, mc);
        if (playerChunk != null) {
            return playerChunk.stub.func_76591_a((int)x, (int)z, (WorldChunkManager)mc.field_71441_e.func_72959_q()).field_76791_y;
        }
        return "?";
    }

    public static boolean playerIsUnderground(EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        if (player.field_70170_p.field_73011_w.field_76576_e) {
            return true;
        }
        int posX = (int)Math.floor(player.field_70165_t);
        int posY = (int)Math.floor(player.field_70163_u) - 1;
        int posZ = (int)Math.floor(player.field_70161_v);
        boolean offset = true;
        int x = 0;
        int y = 0;
        int z = 0;
        boolean blockId = false;
        boolean isUnderground = true;
        block0: for (x = posX - 1; x <= posX + 1; ++x) {
            for (z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                if (!PlayerData.canSeeSky(player.field_70170_p, x, y, z)) continue;
                isUnderground = false;
                break block0;
            }
        }
        return isUnderground;
    }

    private static boolean canSeeSky(World world, int x, int y, int z) {
        boolean seeSky = true;
        int topY = world.func_72825_h(x, z);
        if (y >= topY) {
            return true;
        }
        Chunk chunk = world.func_72938_d(x, z);
        int checkY = topY;
        while (seeSky && checkY > y) {
            try {
                Block block = chunk.func_150810_a(x & 0xF, checkY, z & 0xF);
                if (BlockUtils.hasFlag(block, BlockUtils.Flag.NotHideSky)) {
                    --checkY;
                    continue;
                }
                seeSky = false;
                break;
            }
            catch (Exception e) {
                JourneyMap.getLogger().warning(e + " at " + (x & 0xF) + "," + --checkY + "," + (z & 0xF));
            }
        }
        return seeSky;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }
}

