/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.network.NetworkManager;
import net.minecraft.world.storage.WorldInfo;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.log.LogFormatter;

public class WorldData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(1L);

    @Override
    public Enum[] getKeys() {
        return Key.values();
    }

    public static boolean isHardcoreAndMultiplayer() {
        boolean hardcore = (Boolean)DataCache.instance().get(WorldData.class, null).get((Object)Key.hardcore);
        boolean multiplayer = (Boolean)DataCache.instance().get(WorldData.class, null).get((Object)Key.singlePlayer) == false;
        return hardcore && multiplayer;
    }

    @Override
    public Map getMap(Map optionalParams) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldInfo worldInfo = mc.field_71441_e.func_72912_H();
        LinkedHashMap<Key, Object> props = new LinkedHashMap<Key, Object>();
        props.put(Key.name, WorldData.getWorldName(mc));
        props.put(Key.dimension, mc.field_71441_e.field_73011_w.field_76574_g);
        props.put(Key.hardcore, worldInfo.func_76093_s());
        props.put(Key.singlePlayer, mc.func_71356_B());
        props.put(Key.time, mc.field_71441_e.func_72820_D() % 24000L);
        props.put(Key.features, FeatureManager.getAllowedFeatures());
        return props;
    }

    private static String getServerHash() {
        String serverName = WorldData.getServerName();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            if (md5 != null) {
                byte[] bServerName = serverName.getBytes("UTF-8");
                byte[] hashed = md5.digest(bServerName);
                BigInteger bigInt = new BigInteger(1, hashed);
                String md5Hash = bigInt.toString(16);
                while (md5Hash.length() < 32) {
                    md5Hash = "0" + md5Hash;
                }
                return md5Hash;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverName;
    }

    private static String getServerName() {
        try {
            SocketAddress socketAddress;
            NetworkManager netManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            if (netManager != null && (socketAddress = netManager.func_74430_c()) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    public static String getWorldName(Minecraft mc) {
        String worldName = null;
        if (mc.func_71356_B()) {
            worldName = mc.func_71401_C().func_71221_J();
        } else {
            if (mc.field_71441_e == null) {
                return "offline";
            }
            worldName = mc.field_71441_e.func_72912_H().func_76065_j();
            worldName = !"MpServer".equals(worldName) ? WorldData.getServerName() + "_" + worldName : WorldData.getServerName();
        }
        try {
            worldName = URLEncoder.encode(worldName, "UTF-8").replaceAll("\\+", " ");
        }
        catch (UnsupportedEncodingException e) {
            worldName = "Minecraft";
        }
        return worldName;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }

    public static enum Key {
        dirName,
        name,
        dimension,
        time,
        hardcore,
        singlePlayer,
        features;

    }
}

