/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.feature;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.Minecraft;

public enum Feature {
    NoOp(false, false),
    RadarPlayers(false, true),
    RadarAnimals(false, true),
    RadarMobs(false, true),
    RadarVillagers(false, true),
    MapCaves(false, true);

    private final boolean restrictInSingleplayer;
    private final boolean restrictInMultiplayer;

    private Feature(boolean singlePlayer, boolean multiPlayer) {
        this.restrictInMultiplayer = multiPlayer;
        this.restrictInSingleplayer = singlePlayer;
    }

    public boolean isCurrentlyRestricted() {
        if (this.restrictInMultiplayer && this.restrictInSingleplayer) {
            return true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean isSinglePlayer = mc.func_71356_B();
        if (this.restrictInSingleplayer && isSinglePlayer) {
            return true;
        }
        return this.restrictInMultiplayer && !isSinglePlayer;
    }

    public static Set<Feature> getSubset(boolean restrictSingleplayer, boolean restrictMultiplayer) {
        EnumSet<Feature> subset = EnumSet.noneOf(Feature.class);
        for (Feature feature : Feature.values()) {
            if ((!restrictSingleplayer || !feature.restrictInSingleplayer) && (!restrictMultiplayer || !feature.restrictInMultiplayer)) continue;
            subset.add(feature);
        }
        return Collections.unmodifiableSet(subset);
    }
}

