/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.Utils;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.log.LogFormatter;
import org.lwjgl.Sys;

public class FileHandler {
    public static final String WEB_DIR = "/assets/journeymap/web";
    public static volatile File lastJMWorldDir;
    public static volatile String lastMCFolderName;
    public static volatile File lastMCWorldDir;

    public static File getMCWorldDir(Minecraft minecraft) {
        if (minecraft.func_71387_A()) {
            if (lastMCWorldDir == null || !lastMCFolderName.equals(minecraft.func_71401_C().func_71270_I())) {
                lastMCFolderName = minecraft.func_71401_C().func_71270_I();
                lastMCWorldDir = new File(minecraft.field_71412_D, "saves" + File.separator + lastMCFolderName);
                System.out.println("New world, new dir: " + lastMCWorldDir);
            }
            return lastMCWorldDir;
        }
        return null;
    }

    public static File getMCWorldDir(Minecraft minecraft, int dimension) {
        File worldDir = FileHandler.getMCWorldDir(minecraft);
        if (worldDir == null) {
            return null;
        }
        if (dimension == 0) {
            return worldDir;
        }
        final String dimString = Integer.toString(dimension);
        File dimDir = null;
        if (dimension == -1 || dimension == 1) {
            dimDir = new File(worldDir, "DIM" + dimString);
        }
        if (dimDir == null || !dimDir.exists()) {
            File[] dims = worldDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("DIM") && name.endsWith(dimString) && !name.endsWith("-" + dimString);
                }
            });
            if (dims.length == 0) {
                dimDir = dims[0];
            } else {
                List<File> list = Arrays.asList(dims);
                Collections.sort(list, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return new Integer(o1.getName().length()).compareTo(o2.getName().length());
                    }
                });
                return list.get(0);
            }
        }
        return dimDir;
    }

    public static File getJourneyMapDir() {
        return new File(Minecraft.func_71410_x().field_71412_D, Constants.JOURNEYMAP_DIR);
    }

    public static File getJMWorldDir(Minecraft minecraft) {
        if (!minecraft.func_71356_B()) {
            return FileHandler.getJMWorldDir(minecraft, Utils.getWorldHash(minecraft));
        }
        return FileHandler.getJMWorldDir(minecraft, -1L);
    }

    public static File getJMWorldDir(Minecraft minecraft, long hash) {
        File mcDir = Minecraft.func_71410_x().field_71412_D;
        if (lastJMWorldDir == null) {
            File worldDir = null;
            try {
                String worldName = WorldData.getWorldName(minecraft);
                worldDir = !minecraft.func_71356_B() ? new File(mcDir, Constants.MP_DATA_DIR + worldName + "_" + hash) : new File(mcDir, Constants.SP_DATA_DIR + worldName);
                worldDir.mkdirs();
            }
            catch (Exception e) {
                JourneyMap.getLogger().log(Level.SEVERE, LogFormatter.toString(e));
                throw new RuntimeException(e);
            }
            lastJMWorldDir = worldDir;
        }
        return lastJMWorldDir;
    }

    public static File getAnvilRegionDirectory(File worldDirectory, int dimension) {
        if (dimension == 0) {
            return new File(worldDirectory, "region");
        }
        return new File(worldDirectory, "DIM" + dimension);
    }

    public static BufferedImage getWebImage(String fileName) {
        try {
            String png = "/assets/journeymap/web/img/" + fileName;
            InputStream is = JourneyMap.class.getResourceAsStream(png);
            if (is == null) {
                JourneyMap.getLogger().warning("Image not found: " + png);
                return null;
            }
            BufferedImage img = ImageIO.read(is);
            is.close();
            return img;
        }
        catch (IOException e) {
            String error = Constants.getMessageJMERR17(e.getMessage());
            JourneyMap.getLogger().severe(error);
            return null;
        }
    }

    public static Properties getLangFile(String fileName) {
        try {
            InputStream is = JourneyMap.class.getResourceAsStream("/assets/journeymap/lang/" + fileName);
            if (is == null) {
                JourneyMap.getLogger().warning("Language file not found: " + fileName);
                return null;
            }
            Properties properties = new Properties();
            properties.load(is);
            is.close();
            return properties;
        }
        catch (IOException e) {
            String error = Constants.getMessageJMERR17(e.getMessage());
            JourneyMap.getLogger().severe(error);
            return null;
        }
    }

    public static File getCacheDir() {
        return new File(Minecraft.func_71410_x().field_71412_D, Constants.CACHE_DIR);
    }

    public static File getCustomDir() {
        return new File(Minecraft.func_71410_x().field_71412_D, Constants.CUSTOM_DIR);
    }

    public static BufferedImage getCustomImage(String fileName) {
        try {
            File png = new File(FileHandler.getCustomDir(), "img/" + fileName);
            if (!png.canRead()) {
                return null;
            }
            return ImageIO.read(png);
        }
        catch (IOException e) {
            String error = Constants.getMessageJMERR17(e.getMessage());
            JourneyMap.getLogger().severe(error);
            return null;
        }
    }

    public static void setCustomImage(String fileName, BufferedImage img) {
        try {
            File pngFile = new File(FileHandler.getCustomDir(), "img/" + fileName);
            File parentDir = pngFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            ImageIO.write((RenderedImage)img, "png", pngFile);
        }
        catch (Exception e) {
            String error = Constants.getMessageJMERR00("Can't write custom image " + fileName + ": " + e);
            JourneyMap.getLogger().severe(error);
        }
    }

    public static BufferedImage getCustomizableImage(String fileName, BufferedImage defaultImg) {
        BufferedImage img = null;
        if (FileHandler.getCustomDir().exists()) {
            img = FileHandler.getCustomImage(fileName);
        }
        if (img == null && (img = FileHandler.getWebImage(fileName)) == null) {
            img = defaultImg;
            FileHandler.setCustomImage(fileName, img);
            JourneyMap.getLogger().info("Created placeholder image: " + new File(FileHandler.getCustomDir(), fileName));
        }
        return img;
    }

    public static void open(File file) {
        String path = file.getAbsolutePath();
        if (Util.func_110647_a() == Util.EnumOS.MACOS) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", path});
                return;
            }
            catch (IOException e) {
                JourneyMap.getLogger().severe("Could not open path with /usr/bin/open: " + path + " : " + LogFormatter.toString(e));
            }
        } else if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
            String cmd = String.format("cmd.exe /C start \"Open file\" \"%s\"", path);
            try {
                Runtime.getRuntime().exec(cmd);
                return;
            }
            catch (IOException e) {
                JourneyMap.getLogger().severe("Could not open path with cmd.exe: " + path + " : " + LogFormatter.toString(e));
            }
        }
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object method = desktopClass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(method, file.toURI());
        }
        catch (Throwable e) {
            JourneyMap.getLogger().severe("Could not open path with Desktop: " + path + " : " + LogFormatter.toString(e));
            Sys.openURL((String)("file://" + path));
        }
    }

    public static boolean serializeCache(String name, Serializable cache) {
        try {
            File cacheDir = FileHandler.getCacheDir();
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            File cacheFile = new File(cacheDir, name);
            FileOutputStream fileOut = new FileOutputStream(cacheFile);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(cache);
            out.close();
            fileOut.close();
            return true;
        }
        catch (IOException e) {
            JourneyMap.getLogger().severe("Could not serialize cache: " + name + " : " + LogFormatter.toString(e));
            return false;
        }
    }

    public static boolean writeDebugFile(String name, String contents) {
        try {
            File debugFile = new File(FileHandler.getJourneyMapDir(), "DEBUG-" + name);
            FileWriter writer = new FileWriter(debugFile, false);
            writer.write(contents);
            writer.flush();
            writer.close();
            return true;
        }
        catch (IOException e) {
            JourneyMap.getLogger().severe("Could not write debug file: " + name + " : " + LogFormatter.toString(e));
            return false;
        }
    }

    public static <C extends Serializable> C deserializeCache(String name, Class<C> cacheClass) {
        File cacheFile = new File(FileHandler.getCacheDir(), name);
        if (!cacheFile.exists()) {
            return null;
        }
        try {
            FileInputStream fileIn = new FileInputStream(cacheFile);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Serializable cache = (Serializable)in.readObject();
            in.close();
            fileIn.close();
            if (cache.getClass() != cacheClass) {
                throw new ClassCastException(cache.getClass() + " can't be cast to " + cacheClass);
            }
            return (C)cache;
        }
        catch (Exception e) {
            JourneyMap.getLogger().warning("Could not deserialize cache: " + name + " : " + e);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
            return null;
        }
    }

    static {
        lastMCFolderName = "";
        lastMCWorldDir = null;
    }
}

