/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import org.lwjgl.opengl.GL11;

public class IconLoader {
    Logger logger = JourneyMap.getLogger();
    final BufferedImage blocksTexture;
    HashSet<BlockMD> failed = new HashSet();

    public IconLoader() {
        this.blocksTexture = this.initBlocksTexture();
    }

    public boolean failedFor(BlockMD blockMD) {
        return this.failed.contains(blockMD);
    }

    public Color loadBlockColor(BlockMD blockMD) {
        Color color = null;
        if (this.blocksTexture == null) {
            this.logger.warning("BlocksTexture not yet loaded");
            return null;
        }
        if (this.failed.contains(blockMD)) {
            return null;
        }
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loading color for " + blockMD);
            }
            TextureAtlasSprite blockIcon = null;
            for (int side = blockMD.hasFlag(BlockUtils.Flag.Side2Texture) ? 2 : 1; blockIcon == null && side >= 0; --side) {
                blockIcon = (TextureAtlasSprite)blockMD.getBlock().func_149691_a(side, blockMD.key.meta);
            }
            if (blockIcon == null) {
                this.logger.warning("Could not get Icon for " + blockMD);
            } else {
                color = this.getColorForIcon(blockMD, blockIcon);
            }
            if (color == null) {
                this.failed.add(blockMD);
            }
            return color;
        }
        catch (Throwable t) {
            this.failed.add(blockMD);
            this.logger.severe("Error getting color: " + LogFormatter.toString(t));
            return null;
        }
    }

    Color getColorForIcon(BlockMD blockMD, TextureAtlasSprite icon) {
        Color color = null;
        try {
            int count = 0;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int x = 0;
            int y = 0;
            int xStart = icon.func_130010_a();
            int xStop = xStart + icon.func_94211_a();
            int yStart = icon.func_110967_i();
            int yStop = yStart + icon.func_94216_b();
            block4: for (x = xStart; x < xStop; ++x) {
                for (y = yStart; y < yStop; ++y) {
                    int argb;
                    try {
                        argb = this.blocksTexture.getRGB(x, y);
                    }
                    catch (Throwable e) {
                        this.logger.severe("Couldn't get RGB from BlocksTexture at " + x + "," + y + " for " + blockMD);
                        this.logger.severe(LogFormatter.toString(e));
                        break block4;
                    }
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    ++count;
                    a += alpha;
                    r += argb >> 16 & 0xFF;
                    g += argb >> 8 & 0xFF;
                    b += argb >> 0 & 0xFF;
                }
            }
            if (count > 0) {
                if (a > 0) {
                    a /= count;
                }
                if (r > 0) {
                    r /= count;
                }
                if (g > 0) {
                    g /= count;
                }
                if (b > 0) {
                    b /= count;
                }
            } else {
                this.logger.warning("Unusable texture for " + blockMD);
                b = 0;
                g = 0;
                r = 0;
            }
            color = new Color(r, g, b);
            float blockAlpha = 1.0f;
            Block block = blockMD.getBlock();
            if (BlockUtils.hasAlpha(block)) {
                blockAlpha = BlockUtils.getAlpha(block);
            } else if (blockMD.getBlock().func_149701_w() > 0) {
                blockAlpha = (float)a * 1.0f / 255.0f;
            }
            blockMD.setAlpha(blockAlpha);
        }
        catch (Throwable e1) {
            this.logger.warning("Error deriving color for " + blockMD);
            this.logger.severe(LogFormatter.toString(e1));
        }
        if (color != null && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Derived color for " + blockMD + ": " + Integer.toHexString(color.getRGB()));
        }
        return color;
    }

    private BufferedImage initBlocksTexture() {
        BufferedImage image = null;
        long start = System.currentTimeMillis();
        try {
            int glid = Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_110552_b();
            GL11.glBindTexture((int)3553, (int)glid);
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
            GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
            image = new BufferedImage(width, height, 6);
            byteBuffer.position(0);
            byte[] var4 = new byte[byteBuffer.remaining()];
            byteBuffer.get(var4);
            for (int var5 = 0; var5 < width; ++var5) {
                for (int var6 = 0; var6 < height; ++var6) {
                    int var7 = var6 * width * 4 + var5 * 4;
                    int var8 = 0;
                    int var10 = var8 | (var4[var7 + 2] & 0xFF) << 0;
                    var10 |= (var4[var7 + 1] & 0xFF) << 8;
                    var10 |= (var4[var7 + 0] & 0xFF) << 16;
                    image.setRGB(var5, var6, var10 |= (var4[var7 + 3] & 0xFF) << 24);
                }
            }
            long stop = System.currentTimeMillis();
            this.logger.info("Got blockTexture image in " + (stop - start) + "ms");
        }
        catch (Throwable t) {
            this.logger.severe("Could not load blocksTexture: " + LogFormatter.toString(t));
        }
        return image;
    }
}

