/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import java.util.List;
import java.util.Map;

public class JsonHelper {
    public static String toJson(Map props) {
        StringBuffer sb = new StringBuffer("{");
        Object[] keys = props.keySet().toArray();
        int size = keys.length;
        for (int i = 0; i < size; ++i) {
            Object key = keys[i];
            Object value = props.get(key);
            JsonHelper.wrapAsString(sb, key);
            sb.append(":");
            JsonHelper.wrap(sb, value);
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toJson(List list) {
        return JsonHelper.toJson(list.toArray());
    }

    public static String toJson(Object obj) {
        StringBuffer sb = new StringBuffer();
        JsonHelper.wrap(sb, obj);
        return sb.toString();
    }

    public static String toJson(Object[] arr) {
        StringBuffer sb = new StringBuffer("[");
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            Object value = arr[i];
            JsonHelper.wrap(sb, value);
            if (i + 1 >= size) continue;
            sb.append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }

    static void wrap(StringBuffer sb, Object val) {
        if (val == null) {
            sb.append("null");
        } else if (val instanceof String) {
            JsonHelper.wrapAsString(sb, val);
        } else if (val instanceof Number) {
            sb.append(val);
        } else if (val instanceof Boolean) {
            sb.append(val);
        } else if (val instanceof Map) {
            sb.append(JsonHelper.toJson((Map)val));
        } else if (val instanceof List) {
            sb.append(JsonHelper.toJson((List)val));
        } else if (val.getClass().isArray()) {
            sb.append(JsonHelper.toJson((Object[])val));
        } else {
            JsonHelper.wrapAsString(sb, val);
        }
    }

    static void wrapAsString(StringBuffer sb, Object val) {
        String str = val.toString().replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
        sb.append("'").append(str).append("'");
    }
}

