/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.log;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;

public class ChatLog {
    static final List<ChatComponentTranslation> announcements = Collections.synchronizedList(new LinkedList());

    public static void queueAnnouncement(IChatComponent chat) {
        ChatComponentTranslation wrap = new ChatComponentTranslation("JourneyMap.chat_announcement", new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        ChatComponentText chat = new ChatComponentText(message);
        chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        chat.func_150256_b().func_150228_d(Boolean.valueOf(true));
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceFile(String message, File file) {
        ChatComponentText chat = new ChatComponentText(message);
        try {
            chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getCanonicalPath()));
            chat.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        catch (Exception e) {
            JourneyMap.getLogger().warning("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        ChatComponentText chat = new ChatComponentText(text);
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showChatAnnouncements(Minecraft mc) {
        while (!announcements.isEmpty()) {
            Level logLevel;
            ChatComponentTranslation message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)message);
            }
            catch (Exception e) {
                try {
                    JourneyMap.getLogger().severe("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = message.func_150271_j()[0] instanceof ErrorChat ? Level.SEVERE : Level.INFO;
                    JourneyMap.getLogger().log(logLevel2, StringUtils.func_76338_a((String)message.func_150261_e()));
                    throw throwable;
                }
                logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.SEVERE : Level.INFO;
                JourneyMap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
                continue;
            }
            logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.SEVERE : Level.INFO;
            JourneyMap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
        }
    }

    private static class ErrorChat
    extends ChatComponentText {
        public ErrorChat(String text) {
            super(text);
        }
    }
}

