/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.log;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;

public class JMLogger
extends Logger {
    public static final String LOG_FILE = "journeyMap.log";
    ConsoleHandler consoleHandler;
    java.util.logging.FileHandler logHandler;

    public JMLogger() {
        super("JourneyMap", null);
        this.setLevel(Level.INFO);
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setFormatter(new LogFormatter());
        this.addHandler(this.consoleHandler);
        try {
            File logFile = this.getLogFile();
            if (logFile.exists()) {
                logFile.delete();
            } else {
                FileHandler.getJourneyMapDir().mkdirs();
            }
            this.logHandler = new java.util.logging.FileHandler(logFile.getAbsolutePath());
            this.logHandler.setFormatter(new LogFormatter());
            this.addHandler(this.logHandler);
        }
        catch (SecurityException e) {
            this.severe(LogFormatter.toString(e));
        }
        catch (IOException e) {
            this.severe(LogFormatter.toString(e));
        }
    }

    public void environment() {
        this.info("os.name = " + System.getProperty("os.name") + ", os.arch = " + System.getProperty("os.arch") + ", user.country = " + System.getProperty("user.country") + ", user.language = " + System.getProperty("user.language") + ", java.version = " + System.getProperty("java.version"));
        this.info("Game settings language: " + Minecraft.func_71410_x().field_71474_y.field_74363_ab + " / Locale: " + Constants.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelFromProps() {
        String propLevel = "";
        Level level = Level.INFO;
        try {
            propLevel = PropertyManager.getInstance().getString(PropertyManager.Key.LOGGING_LEVEL);
            level = Level.parse(propLevel);
            if (level != this.getLevel()) {
                this.log(level, "Log level (via journeyMap.properties) set to " + level + ".");
                this.setLevel(level);
                if (level.intValue() < Level.INFO.intValue()) {
                    this.log(level, "THIS LOGGING LEVEL WILL SLOW DOWN THE GAME! DO NOT USE IT UNLESS YOU ARE TROUBLESHOOTING AN ISSUE!");
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.warning("Illegal value for " + (Object)((Object)PropertyManager.Key.LOGGING_LEVEL) + " in " + "journeyMap.properties" + ": " + propLevel);
        }
        catch (Throwable t) {
            this.severe(LogFormatter.toString(t));
        }
        finally {
            this.consoleHandler.setLevel(level);
            this.logHandler.setLevel(level);
        }
    }

    public File getLogFile() {
        return new File(FileHandler.getJourneyMapDir(), LOG_FILE);
    }
}

