/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.io.Serializable;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class BlockMD
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final LoadingCache<CacheKey, BlockMD> cache = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(256).build((CacheLoader)new CacheLoader<CacheKey, BlockMD>(){

        public BlockMD load(CacheKey key) throws Exception {
            return BlockMD.createBlockMD(key);
        }
    });
    public final CacheKey key;
    private transient Block block;
    private Color color;
    private float alpha;
    private final EnumSet<BlockUtils.Flag> flags;
    private final String name;

    public static BlockMD getBlockMD(ChunkMD chunkMd, int x, int y, int z) {
        try {
            int meta;
            Block block;
            boolean isAir = false;
            if (y >= 0) {
                block = chunkMd.stub.func_150810_a(x, y, z);
                isAir = block.isAir((IBlockAccess)chunkMd.worldObj, x, y, z);
                meta = isAir ? 0 : chunkMd.stub.func_76628_c(x, y, z);
            } else {
                block = Blocks.field_150357_h;
                meta = 0;
            }
            CacheKey key = new CacheKey(GameRegistry.findUniqueIdentifierFor((Block)block), meta);
            return (BlockMD)cache.get((Object)key);
        }
        catch (Exception e) {
            JourneyMap.getLogger().severe("Can't get blockId/meta for chunk " + chunkMd.stub.field_76635_g + "," + chunkMd.stub.field_76647_h + " block " + x + "," + y + "," + z);
            JourneyMap.getLogger().severe(LogFormatter.toString(e));
            return null;
        }
    }

    public static BlockMD getBlockMD(GameRegistry.UniqueIdentifier uid, int meta) {
        try {
            return (BlockMD)cache.get((Object)new CacheKey(uid, meta));
        }
        catch (Exception e) {
            JourneyMap.getLogger().severe("Can't get BlockMD for block " + uid + " meta " + meta);
            JourneyMap.getLogger().severe(LogFormatter.toString(e));
            return null;
        }
    }

    private static final BlockMD createBlockMD(CacheKey key) {
        Block block = GameRegistry.findBlock((String)key.uid.modId, (String)key.uid.name);
        if (block == null && (block = GameRegistry.findBlock(null, (String)key.uid.name)) == null) {
            if (!key.uid.name.equals("Air")) {
                JourneyMap.getLogger().warning("Block not found for " + key.uid);
                return new BlockMD(key, Blocks.field_150350_a, "ERROR-" + block.getClass().getName());
            }
            return new BlockMD(key, Blocks.field_150350_a, "Air");
        }
        String prefix = "";
        String suffix = ":" + key.meta;
        String name = key.uid.toString() + suffix;
        try {
            Item item = Item.func_150898_a((Block)block);
            ItemStack stack = new ItemStack(item, 1, block.func_149692_a(key.meta));
            String displayName = stack.func_82833_r();
            if (!key.uid.modId.equals("minecraft")) {
                prefix = key.uid.modId + ":";
            }
            name = prefix + displayName + suffix;
        }
        catch (Throwable t) {
            JourneyMap.getLogger().fine("Displayname not available for " + name);
        }
        BlockMD blockMD = new BlockMD(key, block, name);
        if (blockMD.isAir()) {
            blockMD.color = Color.CYAN;
            blockMD.setAlpha(0.0f);
        } else if (BlockUtils.hasAlpha(block)) {
            blockMD.setAlpha(BlockUtils.getAlpha(block));
        } else {
            blockMD.setAlpha(1.0f);
        }
        return blockMD;
    }

    private BlockMD(CacheKey key, Block block, String name) {
        if (block == null) {
            throw new IllegalArgumentException("Block can't be null");
        }
        this.key = key;
        this.block = block;
        this.name = name;
        this.flags = BlockUtils.getFlags(this.key.uid);
    }

    public boolean hasFlag(BlockUtils.Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public void addFlags(BlockUtils.Flag ... addFlags) {
        for (BlockUtils.Flag flag : addFlags) {
            this.flags.add(flag);
        }
    }

    public RGB getColor(ChunkMD chunkMd, int x, int y, int z) {
        if (this.color != null) {
            return new RGB(this.color);
        }
        Color color = ColorCache.getInstance().getBlockColor(chunkMd, this, x, y, z);
        if (color == null) {
            return new RGB(Color.BLACK);
        }
        if (this.isBiomeColored()) {
            return new RGB(color);
        }
        this.color = color;
        return new RGB(color);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (alpha < 1.0f) {
            this.flags.add(BlockUtils.Flag.Transparency);
        } else {
            this.flags.remove((Object)BlockUtils.Flag.Transparency);
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Block getBlock() {
        if (this.block == null) {
            this.block = GameRegistry.findBlock((String)this.key.uid.modId, (String)this.key.uid.name);
            if (this.block == null) {
                this.block = Blocks.field_150350_a;
            }
        }
        return this.block;
    }

    public boolean isTransparent() {
        return this.block.func_149688_o() == Material.field_151579_a;
    }

    public boolean isAir() {
        return this.hasFlag(BlockUtils.Flag.HasAir);
    }

    public boolean isTorch() {
        this.getBlock();
        return this.block == Blocks.field_150478_aa || this.block == Blocks.field_150429_aA || this.block == Blocks.field_150437_az;
    }

    public boolean isWater() {
        this.getBlock();
        return this.block == Blocks.field_150355_j || this.block == Blocks.field_150358_i;
    }

    public boolean isLava() {
        this.getBlock();
        return this.block == Blocks.field_150353_l || this.block == Blocks.field_150356_k;
    }

    public boolean isFoliage() {
        return this.getBlock() instanceof BlockLeaves;
    }

    public boolean isBiomeColored() {
        return this.flags.contains((Object)BlockUtils.Flag.BiomeColor) || this.flags.contains((Object)BlockUtils.Flag.CustomBiomeColor);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockMD)) {
            return false;
        }
        BlockMD other = (BlockMD)obj;
        return this.key.equals(other.key);
    }

    public String toString() {
        return "BlockMD [" + this.key.uid + " meta " + this.key.meta + "]";
    }

    public String getName() {
        return this.name;
    }

    public static void clearCache() {
        cache.invalidateAll();
    }

    public static final class CacheKey
    implements Serializable {
        public final GameRegistry.UniqueIdentifier uid;
        public final int meta;

        public CacheKey(GameRegistry.UniqueIdentifier uid, int meta) {
            this.uid = uid;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.meta != cacheKey.meta) {
                return false;
            }
            return this.uid.equals((Object)cacheKey.uid);
        }

        public int hashCode() {
            int result = this.uid.hashCode();
            result = 31 * result + this.meta;
            return result;
        }

        public String toString() {
            return this.uid + ":" + this.meta;
        }
    }
}

