/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.ChunkMD;

public class BlockUtils {
    public static AlphaComposite OPAQUE = AlphaComposite.getInstance(3, 1.0f);
    public static AlphaComposite CLEAR = AlphaComposite.getInstance(3, 0.0f);
    public static AlphaComposite SEMICLEAR = AlphaComposite.getInstance(3, 0.5f);
    public static AlphaComposite SLIGHTLYCLEAR = AlphaComposite.getInstance(3, 0.8f);
    public static Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    private static final HashMap<GameRegistry.UniqueIdentifier, EnumSet<Flag>> blockFlags = new HashMap(64);
    private static final HashMap<GameRegistry.UniqueIdentifier, Float> blockAlphas = new HashMap(8);

    public static void initialize() {
        blockAlphas.clear();
        BlockUtils.setAlpha(Blocks.field_150350_a, Float.valueOf(0.0f));
        BlockUtils.setAlpha(Blocks.field_150432_aD, Float.valueOf(0.8f));
        BlockUtils.setAlpha(Blocks.field_150359_w, Float.valueOf(0.3f));
        BlockUtils.setAlpha(Blocks.field_150410_aZ, Float.valueOf(0.3f));
        BlockUtils.setAlpha(Blocks.field_150395_bd, Float.valueOf(0.2f));
        BlockUtils.setAlpha(Blocks.field_150478_aa, Float.valueOf(0.5f));
        blockFlags.clear();
        BlockUtils.setFlags(Blocks.field_150350_a, Flag.HasAir, Flag.NotHideSky, Flag.NoShadow, Flag.NotCeiling);
        BlockUtils.setFlags((Block)Blocks.field_150480_ab, Flag.NoShadow, Flag.Side2Texture);
        BlockUtils.setFlags((Block)Blocks.field_150358_i, Flag.BiomeColor);
        BlockUtils.setFlags((Block)Blocks.field_150349_c, Flag.BiomeColor);
        BlockUtils.setFlags(Blocks.field_150359_w, Flag.NotCeiling, Flag.NoShadow);
        BlockUtils.setFlags(Blocks.field_150410_aZ, Flag.NotCeiling, Flag.NoShadow);
        BlockUtils.setFlags(Blocks.field_150468_ap, Flag.NotHideSky);
        BlockUtils.setFlags(Blocks.field_150353_l, Flag.NoShadow);
        BlockUtils.setFlags((Block)Blocks.field_150362_t, Flag.NotHideSky, Flag.BiomeColor);
        BlockUtils.setFlags((Block)Blocks.field_150361_u, Flag.NotHideSky, Flag.BiomeColor);
        BlockUtils.setFlags(Blocks.field_150429_aA, Flag.HasAir);
        BlockUtils.setFlags(Blocks.field_150478_aa, Flag.HasAir);
        BlockUtils.setFlags((Block)Blocks.field_150329_H, Flag.BiomeColor);
        BlockUtils.setFlags((Block)Blocks.field_150479_bC, Flag.NoShadow);
        BlockUtils.setFlags(Blocks.field_150473_bD, Flag.NoShadow);
        BlockUtils.setFlags(Blocks.field_150437_az, Flag.HasAir);
        BlockUtils.setFlags(Blocks.field_150395_bd, Flag.NotHideSky, Flag.NoShadow, Flag.BiomeColor);
        BlockUtils.setFlags(Blocks.field_150355_j, Flag.NoShadow, Flag.BiomeColor);
        BlockUtils.setFlags(Blocks.field_150321_G, Flag.NotHideSky, Flag.Side2Texture);
        for (Block block : GameData.blockRegistry) {
            if (block.func_149688_o() == Material.field_151579_a) {
                BlockUtils.setFlags(block, Flag.HasAir, Flag.NotHideSky, Flag.NoShadow, Flag.NotCeiling);
                JourneyMap.getLogger().fine(GameRegistry.findUniqueIdentifierFor((Block)block) + " flags set to hide block");
                continue;
            }
            if (block instanceof BlockLeavesBase || block instanceof BlockGrass || block instanceof BlockVine || block instanceof BlockLilyPad) {
                BlockUtils.setFlags(block, Flag.BiomeColor);
                JourneyMap.getLogger().fine(GameRegistry.findUniqueIdentifierFor((Block)block) + " flag set: Flag.BiomeColor");
            }
            if (!(block instanceof BlockBush)) continue;
            BlockUtils.setFlags(block, Flag.Side2Texture, Flag.NoShadow);
            JourneyMap.getLogger().fine(GameRegistry.findUniqueIdentifierFor((Block)block) + " flags set: Flag.Side2Texture, Flag.NoShadow");
        }
    }

    public static boolean skyAbove(ChunkMD chunkMd, int x, int y, int z) {
        boolean seeSky = chunkMd.stub.func_76619_d(x, y, z);
        if (!seeSky) {
            seeSky = true;
            int maxY = chunkMd.stub.func_76611_b(x, z);
            for (int checkY = y; seeSky && checkY <= maxY; ++checkY) {
                Block block = chunkMd.getBlock(x, checkY, z);
                if (BlockUtils.hasFlag(block, Flag.NotHideSky)) {
                    continue;
                }
                seeSky = false;
                break;
            }
        }
        return seeSky;
    }

    public static int ceiling(ChunkMD chunkMd, int x, int maxY, int z) {
        int topY;
        int chunkHeight = chunkMd.stub.func_76611_b(x, z);
        int y = topY = Math.min(maxY, chunkHeight);
        while (y >= 0) {
            Block block = chunkMd.getBlock(x, y, z);
            if (chunkMd.stub.func_76619_d(x, y, z)) {
                --y;
                continue;
            }
            if (BlockUtils.hasFlag(block, Flag.NotCeiling)) {
                --y;
                continue;
            }
            if (!BlockUtils.hasFlag(block, Flag.NotHideSky)) break;
            --y;
        }
        return Math.max(0, y);
    }

    public static EnumSet<Flag> getFlags(GameRegistry.UniqueIdentifier uid) {
        EnumSet<Flag> flags = blockFlags.get(uid);
        return flags == null ? EnumSet.noneOf(Flag.class) : flags;
    }

    public static void setFlags(Block block, Flag ... flags) {
        GameRegistry.UniqueIdentifier uid = GameRegistry.findUniqueIdentifierFor((Block)block);
        EnumSet<Flag> eset = BlockUtils.getFlags(uid);
        eset.addAll(Arrays.asList(flags));
        blockFlags.put(uid, eset);
    }

    public static boolean hasFlag(Block block, Flag flag) {
        EnumSet<Flag> flags = blockFlags.get(GameRegistry.findUniqueIdentifierFor((Block)block));
        return flags != null && flags.contains((Object)flag);
    }

    public static boolean hasAnyFlags(Block block, Flag ... flags) {
        EnumSet<Flag> flagSet = blockFlags.get(GameRegistry.findUniqueIdentifierFor((Block)block));
        if (flagSet == null) {
            return false;
        }
        for (Flag flag : flags) {
            if (!flagSet.contains((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFlag(GameRegistry.UniqueIdentifier uid, Flag flag) {
        EnumSet<Flag> flags = blockFlags.get(uid);
        return flags != null && flags.contains((Object)flag);
    }

    public static boolean hasAlpha(Block block) {
        return blockAlphas.containsKey(GameRegistry.findUniqueIdentifierFor((Block)block));
    }

    public static float getAlpha(Block block) {
        Float alpha = blockAlphas.get(GameRegistry.findUniqueIdentifierFor((Block)block));
        return alpha == null ? 1.0f : alpha.floatValue();
    }

    public static void setAlpha(Block block, Float alpha) {
        blockAlphas.put(GameRegistry.findUniqueIdentifierFor((Block)block), alpha);
    }

    public static HashMap getFlagsMap() {
        return blockFlags;
    }

    public static enum Flag {
        HasAir,
        BiomeColor,
        CustomBiomeColor,
        NotHideSky,
        NotCeiling,
        NoShadow,
        Side2Texture,
        Transparency;

    }
}

