/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderFacade;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;

public class EntityHelper {
    private static int MAX_ENTITIES = 16;
    private static int lateralDistance = PropertyManager.getInstance().getInteger(PropertyManager.Key.CHUNK_OFFSET) * 8;
    private static int verticalDistance = lateralDistance / 2;

    public static List getEntitiesNearby(String timerName, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        Minecraft mc = Minecraft.func_71410_x();
        AxisAlignedBB bb = EntityHelper.getBB((EntityPlayerSP)mc.field_71439_g);
        List list = new ArrayList();
        try {
            for (Class entityClass : entityClasses) {
                list.addAll(mc.field_71441_e.func_72872_a(entityClass, bb));
            }
            if (list.size() > MAX_ENTITIES) {
                Collections.sort(list, new EntityDistanceComparator((EntityPlayer)mc.field_71439_g));
                list = list.subList(0, MAX_ENTITIES);
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().warning("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    public static List getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", IMob.class);
    }

    public static List<EntityVillager> getVillagersNearby() {
        return EntityHelper.getEntitiesNearby("getVillagersNearby", EntityVillager.class);
    }

    public static List<IAnimals> getAnimalsNearby() {
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", EntityAnimal.class, EntityGolem.class, EntityWaterMob.class);
    }

    public static List<EntityPlayer> getPlayersNearby() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_71356_B()) {
            int x = mc.field_71439_g.field_70176_ah << 4;
            int radius = 512;
            int z = mc.field_71439_g.field_70164_aj << 4;
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(x - radius), (double)0.0, (double)(z - radius), (double)(x + radius), (double)mc.field_71441_e.func_72800_K(), (double)(z + radius));
            List list = mc.field_71441_e.func_72872_a(EntityOtherPlayerMP.class, bb);
            if (list.size() > MAX_ENTITIES) {
                Collections.sort(list, new EntityDistanceComparator((EntityPlayer)mc.field_71439_g));
                list = list.subList(0, MAX_ENTITIES);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private static AxisAlignedBB getBB(EntityPlayerSP player) {
        return AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72314_b((double)lateralDistance, (double)verticalDistance, (double)lateralDistance);
    }

    public static double getHeading(Entity entity) {
        if (entity instanceof EntityLiving) {
            return EntityHelper.getHeading(((EntityLiving)entity).field_70759_as);
        }
        return EntityHelper.getHeading(entity.field_70177_z);
    }

    public static double getHeading(float rotationYaw) {
        double degrees = Math.round(rotationYaw % 360.0f);
        return degrees;
    }

    public static Map<Object, Map> buildEntityIdMap(List<LinkedHashMap> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, new EntityMapComparator());
        }
        LinkedHashMap<Object, Map> idMap = new LinkedHashMap<Object, Map>(list.size());
        for (Map map : list) {
            idMap.put("id" + map.get((Object)EntityKey.entityId), map);
        }
        return idMap;
    }

    public static String getFileName(Entity entity) {
        Render entityRender = RenderManager.field_78727_a.func_78713_a(entity);
        if (entityRender instanceof RenderHorse) {
            switch (((EntityHorse)entity).func_110265_bP()) {
                case 1: {
                    return "horse/donkey.png";
                }
                case 2: {
                    return "horse/mule.png";
                }
                case 3: {
                    return "horse/zombiehorse.png";
                }
                case 4: {
                    return "horse/skeletonhorse.png";
                }
            }
            return "horse/horse.png";
        }
        ResourceLocation loc = RenderFacade.getEntityTexture(entityRender, entity);
        if (loc.func_110624_b().equals("minecraft")) {
            String search;
            String tex = loc.func_110623_a();
            int i = tex.lastIndexOf(search = "/entity/");
            if (i >= 0) {
                tex = tex.substring(i + search.length());
            }
            return tex;
        }
        return loc.func_110624_b() + "/" + loc.func_110623_a();
    }

    public static class EntityDistanceComparator
    implements Comparator<Entity> {
        final EntityPlayer player;

        EntityDistanceComparator(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return Double.compare(o1.func_70068_e((Entity)this.player), o2.func_70068_e((Entity)this.player));
        }
    }

    public static class EntityMapComparator
    implements Comparator<Map> {
        @Override
        public int compare(Map o1, Map o2) {
            Integer n;
            Integer n2;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.containsKey((Object)EntityKey.customName)) {
                n2 = o1rank;
                n = o1rank = Integer.valueOf(o1rank + 1);
            } else if (o1.containsKey((Object)EntityKey.username)) {
                o1rank = o1rank + 2;
            }
            if (o2.containsKey((Object)EntityKey.customName)) {
                n2 = o2rank;
                n = o2rank = Integer.valueOf(o2rank + 1);
            } else if (o2.containsKey((Object)EntityKey.username)) {
                o2rank = o2rank + 2;
            }
            return o1rank.compareTo(o2rank);
        }
    }
}

