/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.data.AnimalsData;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.MobsData;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.data.PlayersData;
import net.techbrew.journeymap.data.VillagersData;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.model.WaypointHelper;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.overlay.OverlayRadarRenderer;
import net.techbrew.journeymap.render.overlay.OverlayWaypointRenderer;

public class MapOverlayState {
    final long refreshInterval = PropertyManager.getIntegerProp(PropertyManager.Key.UPDATETIMER_CHUNKS).intValue();
    public final int minZoom = 0;
    public final int maxZoom = 5;
    public boolean follow = true;
    public int currentZoom;
    public double fontScale = 1.0;
    public String playerLastPos = "0,0";
    public boolean minimapEnabled = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_MINIMAP);
    public boolean minimapHotkeys = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_MINIMAP_HOTKEYS);
    private Constants.MapType overrideMapType;
    private File worldDir = null;
    private long lastRefresh = 0L;
    private Integer vSlice = null;
    private boolean underground = false;
    private int dimension = Integer.MIN_VALUE;
    private boolean caveMappingAllowed = false;
    private List<DrawStep> drawStepList = new ArrayList<DrawStep>();
    private String playerBiome = "";

    public void refresh(Minecraft mc, EntityClientPlayerMP player) {
        this.minimapEnabled = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_MINIMAP);
        this.minimapHotkeys = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_MINIMAP_HOTKEYS);
        Constants.MapType lastMapType = this.getMapType();
        boolean lastUnderground = this.underground;
        int lastDimension = this.currentZoom;
        File lastWorldDir = this.worldDir;
        this.caveMappingAllowed = FeatureManager.isAllowed(Feature.MapCaves);
        this.dimension = player.field_71093_bK;
        this.underground = (Boolean)DataCache.playerDataValue(EntityKey.underground);
        this.vSlice = this.underground ? Integer.valueOf(player.field_70162_ai) : null;
        this.worldDir = FileHandler.getJMWorldDir(mc);
        if (player.field_71093_bK != this.dimension) {
            this.follow = true;
        } else if (!this.worldDir.equals(this.worldDir)) {
            this.follow = true;
        } else if (this.getMapType() == Constants.MapType.underground && lastMapType != Constants.MapType.underground) {
            this.follow = true;
        }
        this.playerBiome = (String)DataCache.instance().get(PlayerData.class).get((Object)EntityKey.biome);
        this.updateLastRefresh();
    }

    public void overrideMapType(Constants.MapType mapType) {
        this.overrideMapType = mapType;
        this.requireRefresh();
    }

    public Constants.MapType getMapType() {
        if (this.underground && this.caveMappingAllowed && PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_CAVES).booleanValue()) {
            return Constants.MapType.underground;
        }
        if (this.overrideMapType != null) {
            return this.overrideMapType;
        }
        long ticks = Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L;
        return ticks < 13800L ? Constants.MapType.day : Constants.MapType.night;
    }

    public Integer getVSlice() {
        return this.vSlice;
    }

    public boolean isUnderground() {
        return this.underground;
    }

    public int getDimension() {
        return this.dimension;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public String getPlayerBiome() {
        return this.playerBiome;
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawStepList;
    }

    public void generateDrawSteps(Minecraft mc, GridRenderer gridRenderer, OverlayWaypointRenderer waypointRenderer, OverlayRadarRenderer radarRenderer, float drawScale) {
        Map map;
        this.drawStepList.clear();
        ArrayList<Map> entities = new ArrayList<Map>(16);
        PropertyManager pm = PropertyManager.getInstance();
        if (this.currentZoom > 0) {
            if (FeatureManager.isAllowed(Feature.RadarAnimals) && (pm.getBoolean(PropertyManager.Key.PREF_SHOW_ANIMALS).booleanValue() || pm.getBoolean(PropertyManager.Key.PREF_SHOW_PETS).booleanValue())) {
                map = (Map)DataCache.instance().get(AnimalsData.class).get((Object)EntityKey.root);
                entities.addAll(map.values());
            }
            if (FeatureManager.isAllowed(Feature.RadarVillagers) && pm.getBoolean(PropertyManager.Key.PREF_SHOW_VILLAGERS).booleanValue()) {
                map = (Map)DataCache.instance().get(VillagersData.class).get((Object)EntityKey.root);
                entities.addAll(map.values());
            }
            if (FeatureManager.isAllowed(Feature.RadarMobs) && pm.getBoolean(PropertyManager.Key.PREF_SHOW_MOBS).booleanValue()) {
                map = (Map)DataCache.instance().get(MobsData.class).get((Object)EntityKey.root);
                entities.addAll(map.values());
            }
        }
        if (FeatureManager.isAllowed(Feature.RadarPlayers) && pm.getBoolean(PropertyManager.Key.PREF_SHOW_PLAYERS).booleanValue()) {
            map = (Map)DataCache.instance().get(PlayersData.class).get((Object)EntityKey.root);
            entities.addAll(map.values());
        }
        if (!entities.isEmpty()) {
            Collections.sort(entities, new EntityHelper.EntityMapComparator());
            this.drawStepList.addAll(radarRenderer.prepareSteps(entities, gridRenderer, this.fontScale, drawScale));
        }
        if (WaypointHelper.waypointsEnabled() && PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_WAYPOINTS).booleanValue()) {
            map = (Map)DataCache.instance().get(WaypointsData.class).get((Object)EntityKey.root);
            ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>(map.values());
            this.drawStepList.addAll(waypointRenderer.prepareSteps(waypoints, gridRenderer, this.fontScale));
        }
    }

    public boolean zoomIn() {
        if (this.currentZoom < 5) {
            return this.setZoom(this.currentZoom + 1);
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.currentZoom > 0) {
            return this.setZoom(this.currentZoom - 1);
        }
        return false;
    }

    public boolean setZoom(int zoom) {
        if (zoom > 5 || zoom < 0 || zoom == this.currentZoom) {
            return false;
        }
        this.currentZoom = zoom;
        this.requireRefresh();
        return true;
    }

    public void requireRefresh() {
        this.lastRefresh = 0L;
    }

    public void updateLastRefresh() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public boolean shouldRefresh(Minecraft mc) {
        if (System.currentTimeMillis() > this.lastRefresh + this.refreshInterval) {
            return true;
        }
        return this.dimension != mc.field_71441_e.field_73011_w.field_76574_g;
    }
}

