/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;
import net.techbrew.journeymap.model.ChunkCoord;

public class RegionCoord
implements Comparable<RegionCoord> {
    public final File worldDir;
    public final int regionX;
    public final int regionZ;
    public final Integer vSlice;
    public final int dimension;
    public static final int SIZE = 5;
    private static final int chunkSqRt = (int)Math.pow(2.0, 5.0);

    public static RegionCoord fromChunkPos(File worldDir, int chunkX, Integer vSlice, int chunkZ, int dimension) {
        return new RegionCoord(worldDir, RegionCoord.getRegionPos(chunkX), vSlice, RegionCoord.getRegionPos(chunkZ), dimension);
    }

    public RegionCoord(File worldDir, int regionX, Integer vSlice, int regionZ, int dimension) {
        this.worldDir = worldDir;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.vSlice = vSlice;
        this.dimension = dimension;
    }

    public int getXOffset(int chunkX) {
        if (chunkX >> 5 != this.regionX) {
            throw new IllegalArgumentException("chunkX " + chunkX + " out of bounds for regionX " + this.regionX);
        }
        int offset = chunkX % chunkSqRt * 16;
        if (offset < 0) {
            offset = chunkSqRt * 16 + offset;
        }
        return offset;
    }

    public int getZOffset(int chunkZ) {
        if (RegionCoord.getRegionPos(chunkZ) != this.regionZ) {
            throw new IllegalArgumentException("chunkZ " + chunkZ + " out of bounds for regionZ " + this.regionZ);
        }
        int offset = chunkZ % chunkSqRt * 16;
        if (offset < 0) {
            offset = chunkSqRt * 16 + offset;
        }
        return offset;
    }

    public int getMinChunkX() {
        return RegionCoord.getMinChunkX(this.regionX);
    }

    public int getMaxChunkX() {
        return RegionCoord.getMaxChunkX(this.regionX);
    }

    public static int getMinChunkX(int rX) {
        return rX << 5;
    }

    public static int getMaxChunkX(int rX) {
        return RegionCoord.getMinChunkX(rX) + (int)Math.pow(2.0, 5.0) - 1;
    }

    public int getMinChunkZ() {
        return RegionCoord.getMinChunkZ(this.regionZ);
    }

    public int getMaxChunkZ() {
        return RegionCoord.getMaxChunkZ(this.regionZ);
    }

    public static int getMinChunkZ(int rZ) {
        return rZ << 5;
    }

    public static int getMaxChunkZ(int rZ) {
        return RegionCoord.getMinChunkZ(rZ) + (int)Math.pow(2.0, 5.0) - 1;
    }

    public ChunkCoord getMinChunkCoord() {
        return ChunkCoord.fromChunkPos(this.worldDir, this.getMinChunkX(), this.vSlice, this.getMinChunkZ(), this.dimension);
    }

    public ChunkCoord getMaxChunkCoord() {
        return ChunkCoord.fromChunkPos(this.worldDir, this.getMaxChunkX(), this.vSlice, this.getMaxChunkZ(), this.dimension);
    }

    public List<ChunkCoordIntPair> getChunkCoordsInRegion() {
        ArrayList<ChunkCoordIntPair> list = new ArrayList<ChunkCoordIntPair>(1024);
        ChunkCoord min = this.getMinChunkCoord();
        ChunkCoord max = this.getMaxChunkCoord();
        for (int x = min.chunkX; x <= max.chunkX; ++x) {
            for (int z = min.chunkZ; z <= max.chunkZ; ++z) {
                list.add(new ChunkCoordIntPair(x, z));
            }
        }
        return list;
    }

    public static int getRegionPos(int chunkPos) {
        return chunkPos >> 5;
    }

    public Boolean isUnderground() {
        return this.vSlice != null ? this.vSlice != -1 : false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegionCoord [");
        builder.append(this.regionX);
        builder.append(",");
        builder.append(this.regionZ);
        builder.append("]");
        return builder.toString();
    }

    public Integer getVerticalSlice() {
        if (this.vSlice == null) {
            return -1;
        }
        return this.vSlice;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getVerticalSlice();
        result = 31 * result + this.regionX;
        result = 31 * result + this.regionZ;
        result = 31 * result + (this.worldDir == null ? 0 : this.worldDir.hashCode());
        result = 31 * result + this.dimension;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionCoord other = (RegionCoord)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.regionX != other.regionX) {
            return false;
        }
        if (this.regionZ != other.regionZ) {
            return false;
        }
        if (other.getVerticalSlice() != this.getVerticalSlice()) {
            return false;
        }
        return !(this.worldDir == null ? other.worldDir != null : !this.worldDir.equals(other.worldDir));
    }

    @Override
    public int compareTo(RegionCoord o) {
        int cx = Double.compare(this.regionX, o.regionX);
        return cx == 0 ? Double.compare(this.regionZ, o.regionZ) : cx;
    }
}

