/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.thevoxelbox.voxelmap.VoxelMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import reifnsk.minimap.ReiMinimap;

public class WaypointHelper {
    private static Boolean reiLoaded;
    private static Boolean voxelMapLoaded;
    private static Boolean nativeLoaded;
    private static Boolean renderWaypoints;
    static ArrayList<Waypoint> list;
    static Integer waypointEntityId;

    public static boolean waypointsEnabled() {
        return WaypointHelper.isReiLoaded() || WaypointHelper.isVoxelMapLoaded() || WaypointHelper.isNativeLoaded();
    }

    public static boolean isReiLoaded() {
        if (reiLoaded == null) {
            try {
                Class.forName("reifnsk.minimap.ReiMinimap");
                Class.forName("reifnsk.minimap.Waypoint");
                reiLoaded = Class.forName("reifnsk.minimap.ReiMinimap").getDeclaredField("instance") != null;
            }
            catch (Throwable e) {
                reiLoaded = false;
            }
            if (reiLoaded.booleanValue()) {
                JourneyMap.getLogger().info("Rei's Minimap detected.  Waypoints enabled.");
            }
        }
        return reiLoaded;
    }

    public static boolean isVoxelMapLoaded() {
        if (voxelMapLoaded == null) {
            try {
                Class.forName("com.thevoxelbox.voxelmap.VoxelMap");
                Class.forName("com.thevoxelbox.voxelmap.util.Waypoint");
                voxelMapLoaded = VoxelMap.getInstance() != null;
            }
            catch (Throwable e) {
                voxelMapLoaded = false;
            }
            if (voxelMapLoaded.booleanValue()) {
                JourneyMap.getLogger().info("VoxelMap detected.  Waypoints enabled.");
            }
        }
        return voxelMapLoaded;
    }

    public static boolean isNativeLoaded() {
        return false;
    }

    public static List<Waypoint> getWaypoints() {
        ArrayList<Waypoint> list = new ArrayList<Waypoint>(0);
        if (WaypointHelper.isReiLoaded()) {
            list.addAll(WaypointHelper.getReiWaypoints());
        }
        if (WaypointHelper.isVoxelMapLoaded()) {
            list.addAll(WaypointHelper.getVoxelMapWaypoints());
        }
        return list;
    }

    static List<Waypoint> getReiWaypoints() {
        if (!WaypointHelper.isReiLoaded()) {
            return Collections.EMPTY_LIST;
        }
        try {
            Class.forName("reifnsk.minimap.ReiMinimap").getDeclaredField("instance");
            ReiMinimap reiMinimap = ReiMinimap.instance;
            List wayPts = reiMinimap.getWaypoints();
            if (wayPts == null || wayPts.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Waypoint> converted = new ArrayList<Waypoint>(wayPts.size());
            for (reifnsk.minimap.Waypoint wp : wayPts) {
                converted.add(new Waypoint(wp.name, wp.x, wp.y, wp.z, wp.enable, (int)(wp.red * 255.0f) & 0xFF, (int)(wp.green * 255.0f) & 0xFF, (int)(wp.blue * 255.0f) & 0xFF, wp.type, "rei", wp.toString()));
            }
            return converted;
        }
        catch (Throwable e) {
            JourneyMap.getLogger().severe("Exception getting Rei waypoints: " + LogFormatter.toString(e));
            reiLoaded = false;
            return Collections.EMPTY_LIST;
        }
    }

    static List<Waypoint> getVoxelMapWaypoints() {
        if (!WaypointHelper.isVoxelMapLoaded()) {
            return Collections.EMPTY_LIST;
        }
        try {
            VoxelMap voxelMap = VoxelMap.getInstance();
            ArrayList<Waypoint> wayPts = new ArrayList<Waypoint>(0);
            wayPts.addAll(voxelMap.waypointManager.wayPts);
            if (wayPts.isEmpty()) {
                return wayPts;
            }
            int dimension = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
            int netherOffset = dimension == -1 ? 8 : 1;
            ArrayList<Waypoint> converted = new ArrayList<Waypoint>(wayPts.size());
            for (Object e : wayPts) {
                com.thevoxelbox.voxelmap.util.Waypoint wp = (com.thevoxelbox.voxelmap.util.Waypoint)e;
                if (!wp.isActive()) continue;
                Waypoint convertWp = new Waypoint(wp.name, wp.x / netherOffset, wp.y, wp.z / netherOffset, wp.enabled, (int)(wp.red * 255.0f) & 0xFF, (int)(wp.green * 255.0f) & 0xFF, (int)(wp.blue * 255.0f) & 0xFF, "skull".equals(wp.imageSuffix) ? 1 : 0, "voxelmap", wp.name);
                converted.add(convertWp);
            }
            return converted;
        }
        catch (Throwable e) {
            JourneyMap.getLogger().severe("Exception getting VoxelMap waypoints: " + LogFormatter.toString(e));
            voxelMapLoaded = false;
            return Collections.EMPTY_LIST;
        }
    }

    static List<Waypoint> getNativeWaypoints() {
        if (!WaypointHelper.isNativeLoaded() || renderWaypoints == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public static void initialize() {
    }

    static {
        list = new ArrayList();
    }
}

