/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;

public class DrawCenteredLabelStep
implements DrawStep {
    final double posX;
    final double posZ;
    final String text;
    final int labelYOffset;
    final Color bgColor;
    final Color fgColor;
    final double fontScale;

    public DrawCenteredLabelStep(double posX, double posZ, String text, int labelYOffset, Color bgColor, Color fgColor, double fontScale) {
        this.posX = posX;
        this.posZ = posZ;
        this.text = text;
        this.labelYOffset = labelYOffset;
        this.bgColor = bgColor;
        this.fgColor = fgColor;
        this.fontScale = fontScale;
    }

    @Override
    public void draw(int xOffset, int yOffset, GridRenderer gridRenderer, float scale) {
        Point2D.Double pixel = gridRenderer.getPixel(this.posX, this.posZ);
        if (pixel != null) {
            DrawUtil.drawCenteredLabel(this.text, ((Point2D)pixel).getX() + (double)xOffset, ((Point2D)pixel).getY() + (double)yOffset + (double)this.labelYOffset, this.bgColor, this.fgColor, 205, this.fontScale);
        }
    }
}

