/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DrawWayPointStep
implements DrawStep {
    final int posX;
    final int posZ;
    final TextureImpl texture;
    final TextureImpl offScreenTexture;
    final String label;
    final Color color;
    final Color fontColor;
    final int alpha;
    final double fontScale;

    public DrawWayPointStep(int posX, int posZ, TextureImpl texture, TextureImpl offScreenTexture, String label, Color color, Color fontColor, int alpha, double fontScale) {
        this.posX = posX;
        this.posZ = posZ;
        this.texture = texture;
        this.offScreenTexture = offScreenTexture;
        this.label = label;
        this.color = color;
        this.fontColor = fontColor;
        this.alpha = alpha;
        this.fontScale = fontScale;
    }

    @Override
    public void draw(int xOffset, int yOffset, GridRenderer gridRenderer, float scale) {
        Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(this.posX, this.posZ);
        if (gridRenderer.isOnScreen(((Point2D)pixel).getX(), ((Point2D)pixel).getY())) {
            DrawUtil.drawColoredImage(this.texture, this.alpha, this.color, ((Point2D)pixel).getX() + (double)xOffset - (double)(this.texture.width / 2), ((Point2D)pixel).getY() + (double)yOffset - (double)(this.texture.height / 2));
            DrawUtil.drawCenteredLabel(this.label, ((Point2D)pixel).getX(), ((Point2D)pixel).getY() - (double)this.texture.height, Color.black, this.fontColor, this.alpha, this.fontScale);
        } else {
            gridRenderer.ensureOnScreen(pixel);
            DrawUtil.drawColoredImage(this.offScreenTexture, this.alpha, this.color, ((Point2D)pixel).getX() + (double)xOffset - (double)(this.offScreenTexture.width / 2), ((Point2D)pixel).getY() + (double)yOffset - (double)(this.offScreenTexture.height / 2));
        }
    }
}

