/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.draw.DrawCenteredLabelStep;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class OverlayRadarRenderer {
    public List<DrawStep> prepareSteps(List<Map> critters, GridRenderer grid, double fontScale, float drawScale) {
        boolean showAnimals = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_ANIMALS);
        boolean showPets = PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_PETS);
        int fontHeight = 14;
        Color labelBg = Color.darkGray.darker();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            boolean filterAnimals = showAnimals != showPets;
            String playername = Minecraft.func_71410_x().field_71439_g.getDisplayName();
            TextureCache tc = TextureCache.instance();
            for (Map critter : critters) {
                double posZ;
                double posX;
                Boolean isHostile = Boolean.TRUE.equals(critter.get((Object)EntityKey.hostile));
                String owner = (String)critter.get((Object)EntityKey.owner);
                Boolean isPet = playername.equals(owner);
                if (filterAnimals && !isHostile.booleanValue() && showPets != isPet || grid.getPixel(posX = ((Double)critter.get((Object)EntityKey.posX)).doubleValue(), posZ = ((Double)critter.get((Object)EntityKey.posZ)).doubleValue()) == null) continue;
                String filename = (String)critter.get((Object)EntityKey.filename);
                double heading = (Double)critter.get((Object)EntityKey.heading);
                Boolean isPlayer = filename.startsWith("/skin/");
                TextureImpl locatorImg = isHostile != false ? tc.getHostileLocator() : (isPet != false ? tc.getPetLocator() : (isPlayer != false ? tc.getOtherLocator() : tc.getNeutralLocator()));
                drawStepList.add(new DrawEntityStep(posX, posZ, heading, false, locatorImg, (int)(8.0f * drawScale)));
                TextureImpl entityIcon = isPlayer != false ? tc.getPlayerSkin((String)critter.get((Object)EntityKey.username)) : tc.getEntityImage(filename);
                if (entityIcon != null) {
                    int bottomMargin = isPlayer != false ? 0 : (int)(8.0f * drawScale);
                    drawStepList.add(new DrawEntityStep(posX, posZ, heading, true, entityIcon, bottomMargin));
                }
                if (isPlayer.booleanValue()) {
                    String username = (String)critter.get((Object)EntityKey.username);
                    drawStepList.add(new DrawCenteredLabelStep(posX, posZ, username, -entityIcon.height, labelBg, Color.green, fontScale));
                    continue;
                }
                if (!critter.containsKey((Object)EntityKey.customName)) continue;
                String customName = (String)critter.get((Object)EntityKey.customName);
                drawStepList.add(new DrawCenteredLabelStep(posX, posZ, customName, entityIcon.height / 2, labelBg, Color.white, fontScale));
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

