/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawWayPointStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class OverlayWaypointRenderer {
    final BasicStroke thinStroke = new BasicStroke(2.0f);
    final BasicStroke mediumStroke = new BasicStroke(4.0f);
    final BasicStroke thinRoundStroke = new BasicStroke(2.0f, 1, 1);
    final BasicStroke thickRoundStroke = new BasicStroke(6.0f, 1, 1);

    public List<DrawStep> prepareSteps(List<Waypoint> waypoints, GridRenderer grid, double fontScale) {
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            TextureCache tc = TextureCache.instance();
            for (Waypoint waypoint : waypoints) {
                int wx = waypoint.getX();
                int wz = waypoint.getZ();
                Color color = waypoint.getColor();
                TextureImpl texture = null;
                texture = waypoint.getType() == 1 ? tc.getDeathpoint() : tc.getWaypoint();
                Color labelColor = waypoint.getType() == 1 ? Color.red : color;
                drawStepList.add(new DrawWayPointStep(wx, wz, texture, tc.getWaypointOffscreen(), waypoint.getName(), color, labelColor, 255, fontScale));
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

