/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.texture;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.techbrew.journeymap.log.StatTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class TextureImpl
extends AbstractTexture {
    public final int width;
    public final int height;
    public final boolean retainImage;
    protected BufferedImage image;
    private static final IntBuffer dataBuffer = GLAllocation.func_74527_f((int)0x400000);

    public TextureImpl(BufferedImage image) {
        this(image, false);
    }

    TextureImpl(BufferedImage image, boolean retainImage) {
        this.retainImage = retainImage;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.updateTexture(image, true);
    }

    TextureImpl(int glId, BufferedImage image) {
        this.field_110553_a = glId;
        this.retainImage = true;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    protected void updateTexture(BufferedImage image, boolean allocateMemory) {
        if (image.getWidth() != this.width || image.getHeight() != this.height) {
            throw new IllegalArgumentException("Image dimensions don't match");
        }
        if (this.retainImage) {
            this.image = image;
        }
        if (allocateMemory) {
            TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)image);
        } else {
            GL11.glBindTexture((int)3553, (int)this.func_110552_b());
            TextureImpl.uploadTextureImageSubImpl(image, 0, 0, false, false);
        }
    }

    public void updateTexture(BufferedImage image) {
        this.updateTexture(image, false);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void deleteTexture() {
        if (this.field_110553_a != -1) {
            GL11.glDeleteTextures((int)this.func_110552_b());
        }
        if (this.image != null) {
            this.image = null;
        }
    }

    private static void uploadTextureImageSubImpl(BufferedImage image, int par1, int par2, boolean par3, boolean par4) {
        int var5 = image.getWidth();
        int var6 = image.getHeight();
        int var7 = 0x400000 / var5;
        int[] var8 = new int[var7 * var5];
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        TextureImpl.setTextureBlurred(par3);
        TextureImpl.setTextureClamped(par4);
        StatTimer timer = StatTimer.get("TextureImpl.updateTexture.bind");
        timer.start();
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        timer.stop();
    }

    private static void copyToBuffer(int[] par0ArrayOfInteger, int par1) {
        TextureImpl.copyToBufferPos(par0ArrayOfInteger, 0, par1);
    }

    private static void copyToBufferPos(int[] par0ArrayOfInteger, int par1, int par2) {
        int[] var3 = par0ArrayOfInteger;
        dataBuffer.clear();
        dataBuffer.put(var3, par1, par2);
        dataBuffer.position(0).limit(par2);
    }

    private static void setTextureClamped(boolean par0) {
        if (par0) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
    }

    private static void setTextureBlurred(boolean par0) {
        if (par0) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    public void func_110551_a(IResourceManager par1ResourceManager) {
    }
}

