/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import java.net.URLEncoder;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.AllData;
import net.techbrew.journeymap.data.AnimalsData;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.GameData;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.data.ImagesData;
import net.techbrew.journeymap.data.MessagesData;
import net.techbrew.journeymap.data.MobsData;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.data.PlayersData;
import net.techbrew.journeymap.data.VillagersData;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.server.BaseService;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class DataService
extends BaseService {
    private static final long serialVersionUID = 4412225358529161454L;
    public static final String combinedPath;
    public static final HashMap<String, Class<? extends IDataProvider>> providerMap;

    @Override
    public String path() {
        return combinedPath;
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        Query query = event.query();
        query.parse();
        String path = query.path();
        if (!path.equals("/data/messages")) {
            if (!JourneyMap.getInstance().isMapping().booleanValue()) {
                this.throwEventException(503, Constants.getMessageJMERR02(new Object[0]), event, false);
            } else if (Minecraft.func_71410_x().field_71441_e == null) {
                this.throwEventException(503, Constants.getMessageJMERR09(new Object[0]), event, false);
            }
        }
        Class<? extends IDataProvider> dpClass = providerMap.get(path);
        StringBuffer jsonData = new StringBuffer();
        boolean useJsonP = query.containsKey("callback");
        if (useJsonP) {
            jsonData.append(URLEncoder.encode(query.get("callback").toString(), UTF8.name()));
            jsonData.append("(");
        } else {
            jsonData.append("data=");
        }
        DataCache.instance().appendJson(dpClass, query, jsonData);
        if (useJsonP) {
            jsonData.append(")");
        }
        BaseService.ResponseHeader.on(event).noCache().contentType(BaseService.ContentType.jsonp);
        this.gzipResponse(event, jsonData.toString());
    }

    static {
        providerMap = new HashMap(8);
        providerMap.put("/data/all", AllData.class);
        providerMap.put("/data/animals", AnimalsData.class);
        providerMap.put("/data/mobs", MobsData.class);
        providerMap.put("/data/game", GameData.class);
        providerMap.put("/data/image", ImagesData.class);
        providerMap.put("/data/messages", MessagesData.class);
        providerMap.put("/data/player", PlayerData.class);
        providerMap.put("/data/players", PlayersData.class);
        providerMap.put("/data/world", WorldData.class);
        providerMap.put("/data/villagers", VillagersData.class);
        providerMap.put("/data/waypoints", WaypointsData.class);
        StringBuffer sb = new StringBuffer();
        for (String key : providerMap.keySet()) {
            sb.append(key).append(":");
        }
        combinedPath = sb.toString();
    }
}

